/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.server.state;

import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageTracker {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageTracker.class);
    private volatile long highestContiguousMsgId = -1L;
    private final ConcurrentSkipListSet<Long> nonContiguousMsgIds = new ConcurrentSkipListSet();
    private final Lock reconciliationLock = new ReentrantLock();
    private volatile boolean isSyncCompleted;

    public MessageTracker(boolean isSyncCompleted) {
        this.isSyncCompleted = isSyncCompleted;
    }

    public void track(long msgId) {
        this.nonContiguousMsgIds.add(msgId);
        this.tryReconcile();
    }

    public boolean seen(long msgId) {
        boolean seen = this.nonContiguousMsgIds.contains(msgId) || msgId <= this.highestContiguousMsgId;
        this.tryReconcile();
        return seen;
    }

    public boolean isEmpty() {
        return this.nonContiguousMsgIds.isEmpty();
    }

    public void notifySyncCompleted() {
        this.isSyncCompleted = true;
    }

    private void reconcile() {
        if (this.nonContiguousMsgIds.isEmpty()) {
            return;
        }
        if (this.highestContiguousMsgId == -1L && this.isSyncCompleted) {
            Long min = this.nonContiguousMsgIds.last();
            LOGGER.info("Setting highestContiguousMsgId to {} from -1", (Object)min);
            this.highestContiguousMsgId = min;
            this.nonContiguousMsgIds.removeIf(msgId -> msgId <= min);
        }
        for (long msgId2 : this.nonContiguousMsgIds) {
            if (msgId2 <= this.highestContiguousMsgId) {
                this.nonContiguousMsgIds.remove(msgId2);
                continue;
            }
            if (msgId2 > this.highestContiguousMsgId + 1L) break;
            this.highestContiguousMsgId = msgId2;
            this.nonContiguousMsgIds.remove(msgId2);
        }
    }

    private void tryReconcile() {
        if (!this.reconciliationLock.tryLock()) {
            return;
        }
        try {
            this.reconcile();
            if (this.nonContiguousMsgIds.size() > 500) {
                LOGGER.warn("Non - Contiguous Message ID has size : {}, with highestContiguousMsgId as : {}", (Object)this.nonContiguousMsgIds.size(), (Object)this.highestContiguousMsgId);
            }
        }
        finally {
            this.reconciliationLock.unlock();
        }
    }
}

