/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.server.repo;

import com.tc.classloader.CommonComponent;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityResponse;
import org.ehcache.clustered.common.internal.messages.StateRepositoryOpMessage;
import org.ehcache.clustered.server.internal.messages.EhcacheStateRepoSyncMessage;
import org.ehcache.clustered.server.repo.ServerStateRepository;

@CommonComponent
public class StateRepositoryManager {
    private final ConcurrentMap<String, ServerStateRepository> mapRepositoryMap = new ConcurrentHashMap<String, ServerStateRepository>();

    public void destroyStateRepository(String cacheId) {
        this.mapRepositoryMap.remove(cacheId);
    }

    public EhcacheEntityResponse invoke(StateRepositoryOpMessage message) {
        String cacheId = message.getCacheId();
        ServerStateRepository currentRepo = this.getServerStateRepository(cacheId);
        return currentRepo.invoke(message);
    }

    private ServerStateRepository getServerStateRepository(String cacheId) {
        ServerStateRepository newRepo;
        ServerStateRepository currentRepo = (ServerStateRepository)this.mapRepositoryMap.get(cacheId);
        if (currentRepo == null && (currentRepo = this.mapRepositoryMap.putIfAbsent(cacheId, newRepo = new ServerStateRepository())) == null) {
            currentRepo = newRepo;
        }
        return currentRepo;
    }

    public List<EhcacheStateRepoSyncMessage> syncMessageFor(String cacheId) {
        ServerStateRepository repository = (ServerStateRepository)this.mapRepositoryMap.get(cacheId);
        if (repository != null) {
            return repository.syncMessage(cacheId);
        }
        return Collections.emptyList();
    }

    public void processSyncMessage(EhcacheStateRepoSyncMessage stateRepoSyncMessage) {
        this.getServerStateRepository(stateRepoSyncMessage.getCacheId()).processSyncMessage(stateRepoSyncMessage);
    }
}

