/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.server;

import com.tc.classloader.CommonComponent;
import java.nio.ByteBuffer;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.ehcache.clustered.common.internal.ServerStoreConfiguration;
import org.ehcache.clustered.common.internal.store.Chain;
import org.ehcache.clustered.server.KeySegmentMapper;
import org.ehcache.clustered.server.ServerSideServerStore;
import org.ehcache.clustered.server.ServerStoreEventListener;
import org.ehcache.clustered.server.offheap.OffHeapChainMap;
import org.ehcache.clustered.server.offheap.OffHeapServerStore;
import org.ehcache.clustered.server.state.ResourcePageSource;
import org.terracotta.offheapstore.exceptions.OversizeMappingException;
import org.terracotta.offheapstore.paging.PageSource;

@CommonComponent
public class ServerStoreImpl
implements ServerSideServerStore {
    private final ServerStoreConfiguration storeConfiguration;
    private final ResourcePageSource pageSource;
    private final OffHeapServerStore store;

    public ServerStoreImpl(ServerStoreConfiguration configuration, ResourcePageSource source, KeySegmentMapper mapper, List<OffHeapChainMap<Long>> recoveredMaps) {
        this.storeConfiguration = configuration;
        this.pageSource = source;
        this.store = new OffHeapServerStore(recoveredMaps, mapper);
    }

    public ServerStoreImpl(ServerStoreConfiguration storeConfiguration, ResourcePageSource pageSource, KeySegmentMapper mapper, boolean writeBehindConfigured) {
        this.storeConfiguration = storeConfiguration;
        this.pageSource = pageSource;
        this.store = new OffHeapServerStore(pageSource, mapper, writeBehindConfigured);
    }

    @Override
    public void setEventListener(ServerStoreEventListener listener) {
        this.store.setEventListener(listener);
    }

    @Override
    public void enableEvents(boolean enable) {
        this.store.enableEvents(enable);
    }

    public PageSource getPageSource() {
        return this.pageSource;
    }

    @Override
    public ServerStoreConfiguration getStoreConfiguration() {
        return this.storeConfiguration;
    }

    public Chain get(long key) {
        return this.store.get(key);
    }

    public void append(long key, ByteBuffer payLoad) {
        this.checkPayLoadSize(payLoad);
        this.store.append(key, payLoad);
    }

    public Chain getAndAppend(long key, ByteBuffer payLoad) {
        this.checkPayLoadSize(payLoad);
        return this.store.getAndAppend(key, payLoad);
    }

    public void replaceAtHead(long key, Chain expect, Chain update) {
        this.store.replaceAtHead(key, expect, update);
    }

    @Override
    public void put(long key, Chain chain) {
        this.store.put(key, chain);
    }

    @Override
    public void remove(long key) {
        this.store.remove(key);
    }

    public void clear() {
        this.store.clear();
    }

    public void close() {
        this.store.close();
    }

    @Override
    public List<Set<Long>> getSegmentKeySets() {
        return new AbstractList<Set<Long>>(){

            @Override
            public Set<Long> get(int index) {
                return ServerStoreImpl.this.store.getSegments().get(index).keySet();
            }

            @Override
            public int size() {
                return ServerStoreImpl.this.store.getSegments().size();
            }
        };
    }

    public long getSize() {
        return this.store.getSize();
    }

    public long getTableCapacity() {
        return this.store.getTableCapacity();
    }

    public long getUsedSlotCount() {
        return this.store.getUsedSlotCount();
    }

    public long getRemovedSlotCount() {
        return this.store.getRemovedSlotCount();
    }

    public long getAllocatedMemory() {
        return this.store.getAllocatedMemory();
    }

    public long getOccupiedMemory() {
        return this.store.getOccupiedMemory();
    }

    public long getVitalMemory() {
        return this.store.getVitalMemory();
    }

    public long getDataAllocatedMemory() {
        return this.store.getDataAllocatedMemory();
    }

    public long getDataOccupiedMemory() {
        return this.store.getDataOccupiedMemory();
    }

    public long getDataVitalMemory() {
        return this.store.getDataVitalMemory();
    }

    public long getDataSize() {
        return this.store.getDataSize();
    }

    public int getReprobeLength() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private void checkPayLoadSize(ByteBuffer payLoad) {
        if ((long)payLoad.remaining() > this.pageSource.getPool().getSize()) {
            throw new OversizeMappingException("Payload (" + payLoad.remaining() + ") bigger than pool size (" + this.pageSource.getPool().getSize() + ")");
        }
    }

    public Iterator<Chain> iterator() {
        return this.store.iterator();
    }
}

