/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.management.providers.statistics;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import org.ehcache.Cache;
import org.ehcache.core.spi.service.StatisticsService;
import org.ehcache.core.spi.time.TimeSource;
import org.ehcache.core.statistics.CacheOperationOutcomes;
import org.ehcache.core.statistics.LatencyHistogramConfiguration;
import org.ehcache.management.ManagementRegistryServiceConfiguration;
import org.ehcache.management.providers.CacheBinding;
import org.ehcache.management.providers.ExposedCacheBinding;
import org.terracotta.management.model.capabilities.descriptors.StatisticDescriptor;
import org.terracotta.management.model.stats.Statistic;

public class StandardEhcacheStatistics
extends ExposedCacheBinding {
    private final String cacheAlias;
    private final StatisticsService statisticsService;

    StandardEhcacheStatistics(ManagementRegistryServiceConfiguration registryConfiguration, CacheBinding cacheBinding, StatisticsService statisticsService, TimeSource timeSource) {
        super(registryConfiguration, cacheBinding);
        this.cacheAlias = cacheBinding.getAlias();
        this.statisticsService = statisticsService;
        statisticsService.createCacheRegistry(this.cacheAlias, cacheBinding.getCache(), () -> ((TimeSource)timeSource).getTimeMillis());
        statisticsService.registerCacheStatistics(this.cacheAlias);
        LatencyHistogramConfiguration latencyHistogramConfiguration = registryConfiguration.getLatencyHistogramConfiguration();
        this.registerDerivedStatistics(cacheBinding.getCache(), "get", CacheOperationOutcomes.GetOutcome.HIT, "Cache:GetHitLatency", latencyHistogramConfiguration);
        this.registerDerivedStatistics(cacheBinding.getCache(), "get", CacheOperationOutcomes.GetOutcome.MISS, "Cache:GetMissLatency", latencyHistogramConfiguration);
        this.registerDerivedStatistics(cacheBinding.getCache(), "put", CacheOperationOutcomes.PutOutcome.PUT, "Cache:PutLatency", latencyHistogramConfiguration);
        this.registerDerivedStatistics(cacheBinding.getCache(), "remove", CacheOperationOutcomes.RemoveOutcome.SUCCESS, "Cache:RemoveLatency", latencyHistogramConfiguration);
    }

    private <T extends Enum<T>, K, V> void registerDerivedStatistics(Cache<K, V> cache, String statName, T outcome, String derivedName, LatencyHistogramConfiguration configuration) {
        this.statisticsService.registerDerivedStatistics(this.cacheAlias, cache, statName, outcome, derivedName, configuration);
    }

    public Collection<StatisticDescriptor> getDescriptors() {
        return this.statisticsService.getCacheDescriptors(this.cacheAlias);
    }

    Map<String, Statistic<? extends Serializable>> collectStatistics(Collection<String> statisticNames, long since) {
        return this.statisticsService.collectStatistics(this.cacheAlias, statisticNames, since);
    }
}

