/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.management.providers.settings;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.CacheRuntimeConfiguration;
import org.ehcache.config.ResourcePool;
import org.ehcache.config.ResourceType;
import org.ehcache.config.ResourceUnit;
import org.ehcache.config.SizedResourcePool;
import org.ehcache.config.units.EntryUnit;
import org.ehcache.config.units.MemoryUnit;
import org.ehcache.management.ManagementRegistryServiceConfiguration;
import org.ehcache.management.providers.CacheBinding;
import org.ehcache.management.providers.ExposedCacheBinding;
import org.ehcache.management.providers.settings.Reflect;
import org.terracotta.management.model.capabilities.descriptors.Settings;

class ExposedCacheSettings
extends ExposedCacheBinding {
    private static final Comparator<ResourceType<?>> RESOURCE_TYPE_COMPARATOR = (o1, o2) -> o2.getTierHeight() - o1.getTierHeight();

    ExposedCacheSettings(ManagementRegistryServiceConfiguration registryConfiguration, CacheBinding cacheBinding) {
        super(registryConfiguration, cacheBinding);
    }

    public Collection<Settings> getDescriptors() {
        CacheRuntimeConfiguration cacheConfig = this.cacheBinding.getCache().getRuntimeConfiguration();
        ArrayList resourceTypes = new ArrayList(cacheConfig.getResourcePools().getResourceTypeSet());
        resourceTypes.sort(RESOURCE_TYPE_COMPARATOR);
        LinkedHashMap<String, ResourceType> map = new LinkedHashMap<String, ResourceType>();
        for (ResourceType resourceType : resourceTypes) {
            map.put(resourceType.toString(), resourceType);
        }
        return Collections.singleton(new Settings().set("cacheName", this.cacheBinding.getAlias()).set("keyType", cacheConfig.getKeyType()).set("valueType", cacheConfig.getValueType()).withEach("resourcePools", map, (arg_0, arg_1) -> this.lambda$getDescriptors$1((CacheConfiguration)cacheConfig, arg_0, arg_1)));
    }

    public String getClusterTierExposedAlias(String alias, ResourcePool resourcePool) {
        return alias;
    }

    private /* synthetic */ void lambda$getDescriptors$1(CacheConfiguration cacheConfig, Settings settings, ResourceType type) {
        ResourcePool pool = cacheConfig.getResourcePools().getPoolForResource(type);
        settings.set("level", (Number)type.getTierHeight()).set("persistent", pool.isPersistent());
        if (pool instanceof SizedResourcePool) {
            ResourceUnit unit = ((SizedResourcePool)pool).getUnit();
            settings.set("type", unit instanceof MemoryUnit ? "MEMORY" : (unit instanceof EntryUnit ? "ENTRY" : unit.getClass().getSimpleName().toUpperCase())).set("size", (Number)((SizedResourcePool)pool).getSize()).set("unit", unit.toString());
            if (Reflect.isInstance(pool, "org.ehcache.clustered.client.config.DedicatedClusteredResourcePool")) {
                settings.set("serverResource", Reflect.invoke(pool, "getFromResource", String.class));
                settings.set("clusterTier", this.getClusterTierExposedAlias(this.cacheBinding.getAlias(), pool));
            }
        } else if (Reflect.isInstance(pool, "org.ehcache.clustered.client.config.SharedClusteredResourcePool")) {
            settings.set("serverResource", Reflect.invoke(pool, "getSharedResourcePool", String.class));
            settings.set("clusterTier", this.getClusterTierExposedAlias(this.cacheBinding.getAlias(), pool));
        }
    }
}

