/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.management.registry;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.ehcache.management.ManagementRegistryService;
import org.ehcache.management.registry.DefaultManagementRegistryConfiguration;
import org.ehcache.management.registry.NodeListIterable;
import org.ehcache.spi.service.ServiceCreationConfiguration;
import org.ehcache.xml.CacheManagerServiceConfigurationParser;
import org.ehcache.xml.exceptions.XmlConfigurationException;
import org.w3c.dom.Element;

public class ManagementRegistryServiceConfigurationParser
implements CacheManagerServiceConfigurationParser<ManagementRegistryService> {
    private static final String NAMESPACE = "http://www.ehcache.org/v3/management";
    private static final URI NAMESPACE_URI = URI.create("http://www.ehcache.org/v3/management");
    private static final URL XML_SCHEMA = ManagementRegistryServiceConfigurationParser.class.getResource("/ehcache-management-ext.xsd");

    public Source getXmlSchema() throws IOException {
        return new StreamSource(XML_SCHEMA.openStream());
    }

    public URI getNamespace() {
        return NAMESPACE_URI;
    }

    public ServiceCreationConfiguration<ManagementRegistryService> parseServiceCreationConfiguration(Element fragment) {
        if ("management".equals(fragment.getLocalName())) {
            DefaultManagementRegistryConfiguration registryConfiguration = new DefaultManagementRegistryConfiguration();
            if (fragment.hasAttribute("cache-manager-alias")) {
                registryConfiguration.setCacheManagerAlias(ManagementRegistryServiceConfigurationParser.attr(fragment, "cache-manager-alias"));
            }
            if (fragment.hasAttribute("collector-executor-alias")) {
                registryConfiguration.setCollectorExecutorAlias(ManagementRegistryServiceConfigurationParser.attr(fragment, "collector-executor-alias"));
            }
            for (Element tags : NodeListIterable.elements(fragment, NAMESPACE, "tags")) {
                for (Element tag : NodeListIterable.elements(tags, NAMESPACE, "tag")) {
                    String val = ManagementRegistryServiceConfigurationParser.val(tag);
                    if (val == null || val.isEmpty()) continue;
                    registryConfiguration.addTag(val);
                }
            }
            return registryConfiguration;
        }
        throw new XmlConfigurationException(String.format("XML configuration element <%s> in <%s> is not supported", fragment.getTagName(), fragment.getParentNode() == null ? "null" : fragment.getParentNode().getLocalName()));
    }

    private static String attr(Element element, String name) {
        String s = element.getAttribute(name);
        return s == null || s.equals("") ? null : s;
    }

    private static String val(Element element) {
        return element.hasChildNodes() ? element.getFirstChild().getNodeValue() : null;
    }

    public Class<ManagementRegistryService> getServiceType() {
        return null;
    }

    public Element unparseServiceCreationConfiguration(ServiceCreationConfiguration<ManagementRegistryService> serviceCreationConfiguration) {
        throw new UnsupportedOperationException("Not yet implemented");
    }
}

