/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.management.cluster;

import org.ehcache.management.cluster.ClusteringManagementService;
import org.ehcache.management.cluster.ClusteringManagementServiceConfiguration;
import org.ehcache.management.cluster.DefaultClusteringManagementService;
import org.ehcache.spi.service.Service;
import org.ehcache.spi.service.ServiceProvider;

public class Clustering {
    private static final String ENTITY_SERVICE_FQCN = "org.ehcache.clustered.client.service.EntityService";
    private static final Class<? extends Service> ENTITY_SERVICE_CLASS;

    public static boolean isAvailable(ServiceProvider<Service> serviceProvider) {
        return ENTITY_SERVICE_CLASS != null && serviceProvider.getService(ENTITY_SERVICE_CLASS) != null;
    }

    public static ClusteringManagementService newClusteringManagementService(ClusteringManagementServiceConfiguration configuration) {
        return new DefaultClusteringManagementService(configuration);
    }

    static {
        Class<Service> serviceClass = null;
        try {
            serviceClass = Clustering.class.getClassLoader().loadClass(ENTITY_SERVICE_FQCN).asSubclass(Service.class);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        ENTITY_SERVICE_CLASS = serviceClass;
    }
}

