/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.management.providers.statistics;

import java.util.Collection;
import java.util.Map;
import org.ehcache.core.spi.service.StatisticsService;
import org.ehcache.core.statistics.CacheStatistics;
import org.ehcache.core.statistics.TypedValueStatistic;
import org.ehcache.management.ManagementRegistryServiceConfiguration;
import org.ehcache.management.providers.CacheBinding;
import org.ehcache.management.providers.ExposedCacheBinding;
import org.terracotta.management.model.capabilities.descriptors.StatisticDescriptor;
import org.terracotta.management.registry.collect.StatisticRegistry;
import org.terracotta.statistics.ValueStatistic;

public class StandardEhcacheStatistics
extends ExposedCacheBinding {
    private final StatisticRegistry statisticRegistry;
    private final String cacheName;

    StandardEhcacheStatistics(ManagementRegistryServiceConfiguration registryConfiguration, CacheBinding cacheBinding, StatisticsService statisticsService) {
        super(registryConfiguration, cacheBinding);
        this.cacheName = cacheBinding.getAlias();
        this.statisticRegistry = new StatisticRegistry((Object)cacheBinding.getCache());
        CacheStatistics cacheStatistics = statisticsService.getCacheStatistics(this.cacheName);
        Map knownStatistics = cacheStatistics.getKnownStatistics();
        block4: for (Map.Entry stat : knownStatistics.entrySet()) {
            String name = (String)stat.getKey();
            TypedValueStatistic valueStatistic = (TypedValueStatistic)stat.getValue();
            switch (valueStatistic.getType()) {
                case COUNTER: {
                    this.statisticRegistry.registerCounter(name, (ValueStatistic)valueStatistic);
                    continue block4;
                }
                case SIZE: {
                    this.statisticRegistry.registerSize(name, (ValueStatistic)valueStatistic);
                    continue block4;
                }
            }
            throw new IllegalArgumentException("Unsupported statistic type: " + valueStatistic.getType());
        }
    }

    public Number queryStatistic(String fullStatisticName) {
        return this.statisticRegistry.queryStatistic(fullStatisticName);
    }

    public Map<String, Number> queryStatistics() {
        return this.statisticRegistry.queryStatistics();
    }

    public Collection<StatisticDescriptor> getDescriptors() {
        return this.statisticRegistry.getDescriptors();
    }
}

