/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.management.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.ehcache.Cache;
import org.ehcache.Status;
import org.ehcache.core.events.CacheManagerListener;
import org.ehcache.core.spi.service.CacheManagerProviderService;
import org.ehcache.core.spi.store.InternalCacheManager;
import org.ehcache.impl.internal.concurrent.ConcurrentHashMap;
import org.ehcache.management.ManagementRegistryService;
import org.ehcache.management.SharedManagementService;
import org.ehcache.spi.service.Service;
import org.ehcache.spi.service.ServiceDependencies;
import org.ehcache.spi.service.ServiceProvider;
import org.terracotta.management.model.capabilities.Capability;
import org.terracotta.management.model.context.Context;
import org.terracotta.management.model.context.ContextContainer;
import org.terracotta.management.registry.CapabilityManagement;
import org.terracotta.management.registry.CapabilityManagementSupport;
import org.terracotta.management.registry.DefaultCapabilityManagement;
import org.terracotta.management.registry.ManagementProvider;

@ServiceDependencies(value={CacheManagerProviderService.class, ManagementRegistryService.class})
public class DefaultSharedManagementService
implements SharedManagementService {
    private final ConcurrentMap<Context, ManagementRegistryService> delegates = new ConcurrentHashMap();

    public void start(ServiceProvider<Service> serviceProvider) {
        final ManagementRegistryService managementRegistry = (ManagementRegistryService)serviceProvider.getService(ManagementRegistryService.class);
        final Context cmContext = managementRegistry.getConfiguration().getContext();
        final InternalCacheManager cacheManager = ((CacheManagerProviderService)serviceProvider.getService(CacheManagerProviderService.class)).getCacheManager();
        cacheManager.registerListener(new CacheManagerListener(){

            public void cacheAdded(String alias, Cache<?, ?> cache) {
            }

            public void cacheRemoved(String alias, Cache<?, ?> cache) {
            }

            public void stateTransition(Status from, Status to) {
                switch (to) {
                    case AVAILABLE: {
                        DefaultSharedManagementService.this.delegates.put(cmContext, managementRegistry);
                        break;
                    }
                    case UNINITIALIZED: {
                        DefaultSharedManagementService.this.delegates.remove(cmContext);
                        cacheManager.deregisterListener((CacheManagerListener)this);
                        break;
                    }
                    case MAINTENANCE: {
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Unsupported state: " + to));
                    }
                }
            }
        });
    }

    public void stop() {
    }

    @Override
    public Map<Context, ContextContainer> getContextContainers() {
        HashMap<Context, ContextContainer> contexts = new HashMap<Context, ContextContainer>();
        for (Map.Entry entry : this.delegates.entrySet()) {
            contexts.put((Context)entry.getKey(), ((ManagementRegistryService)entry.getValue()).getContextContainer());
        }
        return contexts;
    }

    @Override
    public Map<Context, Collection<Capability>> getCapabilities() {
        HashMap<Context, Collection<Capability>> capabilities = new HashMap<Context, Collection<Capability>>();
        for (Map.Entry entry : this.delegates.entrySet()) {
            capabilities.put((Context)entry.getKey(), ((ManagementRegistryService)entry.getValue()).getCapabilities());
        }
        return capabilities;
    }

    public Collection<ManagementProvider<?>> getManagementProvidersByCapability(String capabilityName) {
        ArrayList allProviders = new ArrayList();
        for (ManagementRegistryService managementRegistry : this.delegates.values()) {
            allProviders.addAll(managementRegistry.getManagementProvidersByCapability(capabilityName));
        }
        return allProviders;
    }

    public CapabilityManagement withCapability(String capabilityName) {
        return new DefaultCapabilityManagement((CapabilityManagementSupport)this, capabilityName);
    }
}

