/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.management.providers.statistics;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.concurrent.ScheduledExecutorService;
import org.ehcache.core.statistics.CacheOperationOutcomes;
import org.ehcache.core.statistics.TierOperationOutcomes;
import org.ehcache.management.ManagementRegistryServiceConfiguration;
import org.ehcache.management.config.StatisticsProviderConfiguration;
import org.ehcache.management.providers.CacheBinding;
import org.ehcache.management.providers.ExposedCacheBinding;
import org.terracotta.context.extended.OperationStatisticDescriptor;
import org.terracotta.context.extended.StatisticsRegistry;
import org.terracotta.context.extended.ValueStatisticDescriptor;
import org.terracotta.management.model.capabilities.descriptors.Descriptor;
import org.terracotta.management.model.stats.Statistic;
import org.terracotta.management.registry.collect.StatisticsRegistryMetadata;

class StandardEhcacheStatistics
extends ExposedCacheBinding {
    private final StatisticsRegistry statisticsRegistry;
    private final StatisticsRegistryMetadata statisticsRegistryMetadata;

    StandardEhcacheStatistics(ManagementRegistryServiceConfiguration registryConfiguration, CacheBinding cacheBinding, StatisticsProviderConfiguration statisticsProviderConfiguration, ScheduledExecutorService executor) {
        super(registryConfiguration, cacheBinding);
        this.statisticsRegistry = new StatisticsRegistry((Object)cacheBinding.getCache(), executor, statisticsProviderConfiguration.averageWindowDuration(), statisticsProviderConfiguration.averageWindowUnit(), statisticsProviderConfiguration.historySize(), statisticsProviderConfiguration.historyInterval(), statisticsProviderConfiguration.historyIntervalUnit(), statisticsProviderConfiguration.timeToDisable(), statisticsProviderConfiguration.timeToDisableUnit());
        this.statisticsRegistryMetadata = new StatisticsRegistryMetadata(this.statisticsRegistry);
        EnumSet<CacheOperationOutcomes.GetOutcome> hit = EnumSet.of(CacheOperationOutcomes.GetOutcome.HIT_NO_LOADER, CacheOperationOutcomes.GetOutcome.HIT_WITH_LOADER);
        EnumSet<CacheOperationOutcomes.GetOutcome> miss = EnumSet.of(CacheOperationOutcomes.GetOutcome.MISS_NO_LOADER, CacheOperationOutcomes.GetOutcome.MISS_WITH_LOADER);
        OperationStatisticDescriptor getCacheStatisticDescriptor = OperationStatisticDescriptor.descriptor((String)"get", Collections.singleton("cache"), CacheOperationOutcomes.GetOutcome.class);
        this.statisticsRegistry.registerCompoundOperations("Cache:Hit", getCacheStatisticDescriptor, hit);
        this.statisticsRegistry.registerCompoundOperations("Cache:Miss", getCacheStatisticDescriptor, miss);
        this.statisticsRegistry.registerCompoundOperations("Cache:Clear", OperationStatisticDescriptor.descriptor((String)"clear", Collections.singleton("cache"), CacheOperationOutcomes.ClearOutcome.class), EnumSet.allOf(CacheOperationOutcomes.ClearOutcome.class));
        this.statisticsRegistry.registerRatios("Cache:HitRatio", getCacheStatisticDescriptor, hit, EnumSet.allOf(CacheOperationOutcomes.GetOutcome.class));
        this.statisticsRegistry.registerRatios("Cache:MissRatio", getCacheStatisticDescriptor, miss, EnumSet.allOf(CacheOperationOutcomes.GetOutcome.class));
        Class<TierOperationOutcomes.GetOutcome> tierOperationGetOucomeClass = TierOperationOutcomes.GetOutcome.class;
        OperationStatisticDescriptor getTierStatisticDescriptor = OperationStatisticDescriptor.descriptor((String)"get", Collections.singleton("tier"), tierOperationGetOucomeClass);
        this.statisticsRegistry.registerCompoundOperations("Hit", getTierStatisticDescriptor, EnumSet.of(TierOperationOutcomes.GetOutcome.HIT));
        this.statisticsRegistry.registerCompoundOperations("Miss", getTierStatisticDescriptor, EnumSet.of(TierOperationOutcomes.GetOutcome.MISS));
        this.statisticsRegistry.registerCompoundOperations("Eviction", OperationStatisticDescriptor.descriptor((String)"eviction", Collections.singleton("tier"), TierOperationOutcomes.EvictionOutcome.class), EnumSet.allOf(TierOperationOutcomes.EvictionOutcome.class));
        this.statisticsRegistry.registerRatios("HitRatio", getTierStatisticDescriptor, EnumSet.of(TierOperationOutcomes.GetOutcome.HIT), EnumSet.allOf(tierOperationGetOucomeClass));
        this.statisticsRegistry.registerRatios("MissRatio", getTierStatisticDescriptor, EnumSet.of(TierOperationOutcomes.GetOutcome.MISS), EnumSet.allOf(tierOperationGetOucomeClass));
        this.statisticsRegistry.registerCounter("MappingCount", ValueStatisticDescriptor.descriptor((String)"mappings", Collections.singleton("tier")));
        this.statisticsRegistry.registerCounter("MaxMappingCount", ValueStatisticDescriptor.descriptor((String)"maxMappings", Collections.singleton("tier")));
        this.statisticsRegistry.registerSize("AllocatedByteSize", ValueStatisticDescriptor.descriptor((String)"allocatedMemory", Collections.singleton("tier")));
        this.statisticsRegistry.registerSize("OccupiedByteSize", ValueStatisticDescriptor.descriptor((String)"occupiedMemory", Collections.singleton("tier")));
    }

    Statistic<?, ?> queryStatistic(String fullStatisticName, long since) {
        return this.statisticsRegistryMetadata.queryStatistic(fullStatisticName, since);
    }

    @Override
    public Collection<? extends Descriptor> getDescriptors() {
        return this.statisticsRegistryMetadata.getDescriptors();
    }

    void dispose() {
        this.statisticsRegistry.clearRegistrations();
    }
}

