/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.management.registry;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class NodeListIterable<T extends Node>
implements Iterable<T> {
    private final NodeList nodeList;
    private final Class<T> type;

    private NodeListIterable(NodeList nodeList, Class<T> type) {
        this.nodeList = nodeList;
        this.type = type;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return NodeListIterable.this.nodeList != null && this.i < NodeListIterable.this.nodeList.getLength();
            }

            @Override
            public T next() throws NoSuchElementException {
                Node node;
                if (!this.hasNext() || (node = NodeListIterable.this.nodeList.item(this.i++)) == null) {
                    throw new NoSuchElementException();
                }
                return (Node)NodeListIterable.this.type.cast(node);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    static Iterable<Element> elements(Element root, String ns, String localName) {
        return new NodeListIterable<Element>(root.getElementsByTagNameNS(ns, localName), Element.class);
    }
}

