/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.management.providers.settings;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.ehcache.CacheManager;
import org.ehcache.core.HumanReadable;
import org.ehcache.management.ManagementRegistryServiceConfiguration;
import org.ehcache.management.providers.CacheBinding;
import org.ehcache.management.providers.CacheBindingManagementProvider;
import org.ehcache.management.providers.settings.ExposedCacheSettings;
import org.terracotta.management.model.capabilities.descriptors.Descriptor;
import org.terracotta.management.model.capabilities.descriptors.Settings;
import org.terracotta.management.registry.Named;
import org.terracotta.management.registry.RequiredContext;

@Named(value="SettingsCapability")
@RequiredContext(value={@Named(value="instanceId"), @Named(value="cacheManagerName")})
public class EhcacheSettingsProvider
extends CacheBindingManagementProvider {
    private final ManagementRegistryServiceConfiguration configuration;
    private final CacheManager cacheManager;

    public EhcacheSettingsProvider(ManagementRegistryServiceConfiguration configuration, CacheManager cacheManager) {
        super(configuration);
        this.configuration = configuration;
        this.cacheManager = cacheManager;
    }

    @Override
    protected ExposedCacheSettings wrap(CacheBinding cacheBinding) {
        return new ExposedCacheSettings(this.registryConfiguration, cacheBinding);
    }

    public Collection<? extends Descriptor> getDescriptors() {
        ArrayList<Descriptor> descriptors = new ArrayList<Descriptor>(super.getDescriptors());
        descriptors.add(this.cacheManagerSettings());
        return descriptors;
    }

    private Descriptor cacheManagerSettings() {
        return new Settings().set("cacheManagerDescription", ((HumanReadable)this.cacheManager.getRuntimeConfiguration()).readableString()).set("instanceId", this.configuration.getInstanceId()).set("managementContext", new Settings((Map)this.registryConfiguration.getContext())).set("tags", this.registryConfiguration.getTags().toArray(new String[0]));
    }
}

