/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.management.registry;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.ehcache.management.ManagementRegistryService;
import org.ehcache.management.ManagementRegistryServiceConfiguration;
import org.ehcache.management.registry.LatencyHistogramConfiguration;
import org.terracotta.management.model.context.Context;

public class DefaultManagementRegistryConfiguration
implements ManagementRegistryServiceConfiguration {
    private static final AtomicLong COUNTER = new AtomicLong();
    private final Collection<String> tags = new TreeSet<String>();
    private final String instanceId = UUID.randomUUID().toString();
    private Context context = Context.empty().with("instanceId", this.instanceId);
    private String collectorExecutorAlias = "collectorExecutor";
    private LatencyHistogramConfiguration latencyHistogramConfiguration = LatencyHistogramConfiguration.DEFAULT;

    public DefaultManagementRegistryConfiguration() {
        this.setCacheManagerAlias("cache-manager-" + COUNTER.getAndIncrement());
    }

    public DefaultManagementRegistryConfiguration setCacheManagerAlias(String alias) {
        return this.setContext(Context.create((String)"cacheManagerName", (String)alias));
    }

    public DefaultManagementRegistryConfiguration setContext(Context context) {
        if (!this.context.contains("cacheManagerName") && !context.contains("cacheManagerName")) {
            throw new IllegalArgumentException("'cacheManagerName' is missing from context");
        }
        if (context.contains("instanceId") && !Objects.equals(context.get("instanceId"), this.instanceId)) {
            throw new IllegalArgumentException("Cannot override instanceId in context " + this.context + " by " + context);
        }
        this.context = this.context.with((Map)context);
        return this;
    }

    public DefaultManagementRegistryConfiguration setCollectorExecutorAlias(String collectorExecutorAlias) {
        this.collectorExecutorAlias = collectorExecutorAlias;
        return this;
    }

    public DefaultManagementRegistryConfiguration addTags(String ... tags) {
        this.tags.addAll(Arrays.asList(tags));
        return this;
    }

    public DefaultManagementRegistryConfiguration addTag(String tag) {
        return this.addTags(tag);
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    public String getCacheManagerAlias() {
        return this.getContext().get("cacheManagerName");
    }

    @Override
    public String getCollectorExecutorAlias() {
        return this.collectorExecutorAlias;
    }

    @Override
    public Collection<String> getTags() {
        return this.tags;
    }

    @Override
    public String getInstanceId() {
        return this.instanceId;
    }

    @Override
    public LatencyHistogramConfiguration getLatencyHistogramConfiguration() {
        return this.latencyHistogramConfiguration;
    }

    public DefaultManagementRegistryConfiguration setLatencyHistogramConfiguration(LatencyHistogramConfiguration latencyHistogramConfiguration) {
        this.latencyHistogramConfiguration = Objects.requireNonNull(latencyHistogramConfiguration);
        return this;
    }

    public Class<ManagementRegistryService> getServiceType() {
        return ManagementRegistryService.class;
    }

    public String toString() {
        return "DefaultManagementRegistryConfiguration{context=" + this.context + ", tags=" + this.tags + ", collectorExecutorAlias='" + this.collectorExecutorAlias + '\'' + ", instanceId='" + this.instanceId + '\'' + ", latencyHistogramConfiguration='" + this.latencyHistogramConfiguration + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultManagementRegistryConfiguration that = (DefaultManagementRegistryConfiguration)o;
        return Objects.equals(this.tags, that.tags) && Objects.equals(this.instanceId, that.instanceId) && Objects.equals(this.context, that.context) && Objects.equals(this.collectorExecutorAlias, that.collectorExecutorAlias) && Objects.equals(this.latencyHistogramConfiguration, that.latencyHistogramConfiguration);
    }

    public int hashCode() {
        return Objects.hash(this.tags, this.instanceId, this.context, this.collectorExecutorAlias);
    }
}

