/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.management.registry;

import java.net.URI;
import java.util.Collections;
import org.ehcache.management.ManagementRegistryService;
import org.ehcache.management.registry.DefaultManagementRegistryConfiguration;
import org.ehcache.management.registry.NodeListIterable;
import org.ehcache.xml.BaseConfigParser;
import org.ehcache.xml.CacheManagerServiceConfigurationParser;
import org.ehcache.xml.ParsingUtil;
import org.ehcache.xml.exceptions.XmlConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ManagementRegistryServiceConfigurationParser
extends BaseConfigParser<DefaultManagementRegistryConfiguration>
implements CacheManagerServiceConfigurationParser<ManagementRegistryService, DefaultManagementRegistryConfiguration> {
    private static final String NAMESPACE = "http://www.ehcache.org/v3/management";
    private static final String MANAGEMENT_NAMESPACE_PREFIX = "mgm:";
    private static final String MANAGEMENT_ELEMENT_NAME = "management";
    private static final String CACHE_MANAGER_ATTRIBUTE_NAME = "cache-manager-alias";
    private static final String COLLECTOR_EXECUTOR_ATTRIBUTE_NAME = "collector-executor-alias";
    private static final String TAGS_NAME = "tags";
    private static final String TAG_NAME = "tag";

    public ManagementRegistryServiceConfigurationParser() {
        super(Collections.singletonMap(URI.create(NAMESPACE), ManagementRegistryServiceConfigurationParser.class.getResource("/ehcache-management-ext.xsd")));
    }

    public DefaultManagementRegistryConfiguration parse(Element fragment, ClassLoader classLoader) {
        if (MANAGEMENT_ELEMENT_NAME.equals(fragment.getLocalName())) {
            DefaultManagementRegistryConfiguration registryConfiguration = new DefaultManagementRegistryConfiguration();
            if (fragment.hasAttribute(CACHE_MANAGER_ATTRIBUTE_NAME)) {
                registryConfiguration.setCacheManagerAlias(ManagementRegistryServiceConfigurationParser.attr(fragment, CACHE_MANAGER_ATTRIBUTE_NAME));
            }
            if (fragment.hasAttribute(COLLECTOR_EXECUTOR_ATTRIBUTE_NAME)) {
                registryConfiguration.setCollectorExecutorAlias(ManagementRegistryServiceConfigurationParser.attr(fragment, COLLECTOR_EXECUTOR_ATTRIBUTE_NAME));
            }
            for (Element tags : NodeListIterable.elements(fragment, NAMESPACE, TAGS_NAME)) {
                for (Element tag : NodeListIterable.elements(tags, NAMESPACE, TAG_NAME)) {
                    String val = ParsingUtil.parsePropertyOrString((String)tag.getTextContent());
                    if (val.isEmpty()) continue;
                    registryConfiguration.addTag(val);
                }
            }
            return registryConfiguration;
        }
        throw new XmlConfigurationException(String.format("XML configuration element <%s> in <%s> is not supported", fragment.getTagName(), fragment.getParentNode() == null ? "null" : fragment.getParentNode().getLocalName()));
    }

    private static String attr(Element element, String name) {
        String s = element.getAttribute(name);
        return s == null || s.equals("") ? null : s;
    }

    public Class<ManagementRegistryService> getServiceType() {
        return ManagementRegistryService.class;
    }

    public Element safeUnparse(Document doc, DefaultManagementRegistryConfiguration defaultManagementRegistryConfiguration) {
        Element rootElement = doc.createElementNS(NAMESPACE, "mgm:management");
        rootElement.setAttribute(CACHE_MANAGER_ATTRIBUTE_NAME, defaultManagementRegistryConfiguration.getCacheManagerAlias());
        rootElement.setAttribute(COLLECTOR_EXECUTOR_ATTRIBUTE_NAME, defaultManagementRegistryConfiguration.getCollectorExecutorAlias());
        this.processManagementTags(doc, rootElement, defaultManagementRegistryConfiguration);
        return rootElement;
    }

    private void processManagementTags(Document doc, Element parent, DefaultManagementRegistryConfiguration defaultManagementRegistryConfiguration) {
        if (!defaultManagementRegistryConfiguration.getTags().isEmpty()) {
            Element tagsName = doc.createElementNS(NAMESPACE, "mgm:tags");
            for (String tag : defaultManagementRegistryConfiguration.getTags()) {
                Element tagName = doc.createElementNS(NAMESPACE, "mgm:tag");
                tagName.setTextContent(tag);
                tagsName.appendChild(tagName);
            }
            parent.appendChild(tagsName);
        }
    }
}

