/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.management.config;

import java.util.concurrent.TimeUnit;
import org.ehcache.management.config.StatisticsProviderConfiguration;
import org.terracotta.management.model.Objects;
import org.terracotta.management.registry.ManagementProvider;

public class DefaultStatisticsProviderConfiguration
implements StatisticsProviderConfiguration {
    private final Class<? extends ManagementProvider> provider;
    private long averageWindowDuration = 60L;
    private TimeUnit averageWindowUnit = TimeUnit.SECONDS;
    private int historySize = 100;
    private long historyInterval = 1L;
    private TimeUnit historyIntervalUnit = TimeUnit.SECONDS;
    private long timeToDisable = 30L;
    private TimeUnit timeToDisableUnit = TimeUnit.SECONDS;

    public DefaultStatisticsProviderConfiguration(Class<? extends ManagementProvider> provider, long averageWindowDuration, TimeUnit averageWindowUnit, int historySize, long historyInterval, TimeUnit historyIntervalUnit, long timeToDisable, TimeUnit timeToDisableUnit) {
        this.provider = (Class)Objects.requireNonNull(provider);
        this.averageWindowDuration = averageWindowDuration;
        this.averageWindowUnit = (TimeUnit)((Object)Objects.requireNonNull((Object)((Object)averageWindowUnit)));
        this.historySize = historySize;
        this.historyInterval = historyInterval;
        this.historyIntervalUnit = (TimeUnit)((Object)Objects.requireNonNull((Object)((Object)historyIntervalUnit)));
        this.timeToDisable = timeToDisable;
        this.timeToDisableUnit = (TimeUnit)((Object)Objects.requireNonNull((Object)((Object)timeToDisableUnit)));
    }

    public DefaultStatisticsProviderConfiguration(Class<? extends ManagementProvider> provider) {
        this.provider = (Class)Objects.requireNonNull(provider);
    }

    @Override
    public long averageWindowDuration() {
        return this.averageWindowDuration;
    }

    @Override
    public TimeUnit averageWindowUnit() {
        return this.averageWindowUnit;
    }

    @Override
    public int historySize() {
        return this.historySize;
    }

    @Override
    public long historyInterval() {
        return this.historyInterval;
    }

    @Override
    public TimeUnit historyIntervalUnit() {
        return this.historyIntervalUnit;
    }

    @Override
    public long timeToDisable() {
        return this.timeToDisable;
    }

    @Override
    public TimeUnit timeToDisableUnit() {
        return this.timeToDisableUnit;
    }

    @Override
    public Class<? extends ManagementProvider> getStatisticsProviderType() {
        return this.provider;
    }

    public String toString() {
        return "{statisticsProviderType=" + this.getStatisticsProviderType() + ", averageWindowDuration=" + this.averageWindowDuration() + ", averageWindowUnit=" + (Object)((Object)this.averageWindowUnit()) + ", historyInterval=" + this.historyInterval() + ", historyIntervalUnit=" + (Object)((Object)this.historyIntervalUnit()) + ", historySize=" + this.historySize() + ", timeToDisable=" + this.timeToDisable() + ", timeToDisableUnit=" + (Object)((Object)this.timeToDisableUnit()) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultStatisticsProviderConfiguration that = (DefaultStatisticsProviderConfiguration)o;
        if (!this.provider.equals(that.provider)) {
            return false;
        }
        if (this.averageWindowDuration != that.averageWindowDuration) {
            return false;
        }
        if (this.historySize != that.historySize) {
            return false;
        }
        if (this.historyInterval != that.historyInterval) {
            return false;
        }
        if (this.timeToDisable != that.timeToDisable) {
            return false;
        }
        if (this.averageWindowUnit != that.averageWindowUnit) {
            return false;
        }
        if (this.historyIntervalUnit != that.historyIntervalUnit) {
            return false;
        }
        return this.timeToDisableUnit == that.timeToDisableUnit;
    }

    public int hashCode() {
        int result = (int)(this.averageWindowDuration ^ this.averageWindowDuration >>> 32);
        result = 31 * result + this.provider.hashCode();
        result = 31 * result + this.averageWindowUnit.hashCode();
        result = 31 * result + this.historySize;
        result = 31 * result + (int)(this.historyInterval ^ this.historyInterval >>> 32);
        result = 31 * result + this.historyIntervalUnit.hashCode();
        result = 31 * result + (int)(this.timeToDisable ^ this.timeToDisable >>> 32);
        result = 31 * result + this.timeToDisableUnit.hashCode();
        return result;
    }

    public DefaultStatisticsProviderConfiguration setAverageWindowDuration(long averageWindowDuration) {
        this.averageWindowDuration = averageWindowDuration;
        return this;
    }

    public DefaultStatisticsProviderConfiguration setAverageWindowUnit(TimeUnit averageWindowUnit) {
        this.averageWindowUnit = averageWindowUnit;
        return this;
    }

    public DefaultStatisticsProviderConfiguration setHistoryInterval(long historyInterval) {
        this.historyInterval = historyInterval;
        return this;
    }

    public DefaultStatisticsProviderConfiguration setHistoryIntervalUnit(TimeUnit historyIntervalUnit) {
        this.historyIntervalUnit = historyIntervalUnit;
        return this;
    }

    public DefaultStatisticsProviderConfiguration setHistorySize(int historySize) {
        this.historySize = historySize;
        return this;
    }

    public DefaultStatisticsProviderConfiguration setTimeToDisable(long timeToDisable) {
        this.timeToDisable = timeToDisable;
        return this;
    }

    public DefaultStatisticsProviderConfiguration setTimeToDisableUnit(TimeUnit timeToDisableUnit) {
        this.timeToDisableUnit = timeToDisableUnit;
        return this;
    }
}

