/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.management.registry;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.ehcache.management.ManagementRegistryService;
import org.ehcache.management.ManagementRegistryServiceConfiguration;
import org.ehcache.management.config.EhcacheStatisticsProviderConfiguration;
import org.ehcache.management.config.StatisticsProviderConfiguration;
import org.terracotta.management.context.Context;
import org.terracotta.management.registry.ManagementProvider;

public class DefaultManagementRegistryConfiguration
implements ManagementRegistryServiceConfiguration {
    private static final AtomicLong COUNTER = new AtomicLong();
    private final Map<Class<? extends ManagementProvider>, StatisticsProviderConfiguration<?>> configurationMap = new HashMap();
    private Context context = Context.empty();
    private String statisticsExecutorAlias;
    private String collectorExecutorAlias;

    public DefaultManagementRegistryConfiguration() {
        this.setCacheManagerAlias("cache-manager-" + COUNTER.getAndIncrement());
        this.addConfiguration(new EhcacheStatisticsProviderConfiguration(1L, TimeUnit.MINUTES, 100, 1L, TimeUnit.SECONDS, 30L, TimeUnit.SECONDS));
    }

    public DefaultManagementRegistryConfiguration setCacheManagerAlias(String alias) {
        return this.setContext(Context.create((String)"cacheManagerName", (String)alias));
    }

    public DefaultManagementRegistryConfiguration setContext(Context context) {
        if (!this.context.contains("cacheManagerName") && !context.contains("cacheManagerName")) {
            throw new IllegalArgumentException("'cacheManagerName' is missing from context");
        }
        this.context = this.context.with((Map)context);
        return this;
    }

    public DefaultManagementRegistryConfiguration setStatisticsExecutorAlias(String alias) {
        this.statisticsExecutorAlias = alias;
        return this;
    }

    public DefaultManagementRegistryConfiguration setCollectorExecutorAlias(String collectorExecutorAlias) {
        this.collectorExecutorAlias = collectorExecutorAlias;
        return this;
    }

    public DefaultManagementRegistryConfiguration addConfiguration(StatisticsProviderConfiguration<?> configuration) {
        Class<?> serviceType = configuration.getStatisticsProviderType();
        this.configurationMap.put(serviceType, configuration);
        return this;
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public String getStatisticsExecutorAlias() {
        return this.statisticsExecutorAlias;
    }

    @Override
    public String getCollectorExecutorAlias() {
        return this.collectorExecutorAlias;
    }

    @Override
    public StatisticsProviderConfiguration getConfigurationFor(Class<? extends ManagementProvider<?>> managementProviderClass) {
        return this.configurationMap.get(managementProviderClass);
    }

    public Class<ManagementRegistryService> getServiceType() {
        return ManagementRegistryService.class;
    }
}

