/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.management.registry;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.ehcache.Cache;
import org.ehcache.Status;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.core.events.CacheManagerListener;
import org.ehcache.core.spi.cache.InternalCacheManager;
import org.ehcache.core.spi.service.CacheManagerProviderService;
import org.ehcache.core.spi.service.ExecutionService;
import org.ehcache.impl.internal.executor.ExecutorUtil;
import org.ehcache.management.ManagementRegistryService;
import org.ehcache.management.ManagementRegistryServiceConfiguration;
import org.ehcache.management.providers.CacheBinding;
import org.ehcache.management.providers.EhcacheStatisticCollectorProvider;
import org.ehcache.management.providers.actions.EhcacheActionProvider;
import org.ehcache.management.providers.statistics.EhcacheStatisticsProvider;
import org.ehcache.management.registry.DefaultManagementRegistryConfiguration;
import org.ehcache.spi.ServiceProvider;
import org.ehcache.spi.service.Service;
import org.ehcache.spi.service.ServiceDependencies;
import org.terracotta.management.context.ContextContainer;
import org.terracotta.management.registry.AbstractManagementRegistry;
import org.terracotta.management.registry.ManagementProvider;
import org.terracotta.statistics.StatisticsManager;

@ServiceDependencies(value={CacheManagerProviderService.class, ExecutionService.class})
public class DefaultManagementRegistryService
extends AbstractManagementRegistry
implements ManagementRegistryService,
CacheManagerListener {
    private final ManagementRegistryServiceConfiguration configuration;
    private volatile ScheduledExecutorService statisticsExecutor;
    private volatile InternalCacheManager cacheManager;

    public DefaultManagementRegistryService() {
        this(new DefaultManagementRegistryConfiguration());
    }

    public DefaultManagementRegistryService(ManagementRegistryServiceConfiguration configuration) {
        this.configuration = configuration == null ? new DefaultManagementRegistryConfiguration() : configuration;
    }

    public void start(ServiceProvider<Service> serviceProvider) {
        this.statisticsExecutor = ((ExecutionService)serviceProvider.getService(ExecutionService.class)).getScheduledExecutor(this.configuration.getStatisticsExecutorAlias());
        this.cacheManager = ((CacheManagerProviderService)serviceProvider.getService(CacheManagerProviderService.class)).getCacheManager();
        this.addManagementProvider((ManagementProvider)new EhcacheActionProvider(this.getConfiguration().getContext()));
        this.addManagementProvider((ManagementProvider)new EhcacheStatisticsProvider(this.getConfiguration().getContext(), this.getConfiguration().getConfigurationFor(EhcacheStatisticsProvider.class), this.statisticsExecutor));
        this.addManagementProvider((ManagementProvider)new EhcacheStatisticCollectorProvider(this.getConfiguration().getContext()));
        this.cacheManager.registerListener((CacheManagerListener)this);
    }

    public void stop() {
        for (ManagementProvider managementProvider : this.managementProviders) {
            managementProvider.close();
        }
        this.managementProviders.clear();
        ExecutorUtil.shutdownNow((ExecutorService)this.statisticsExecutor);
    }

    public void cacheAdded(String alias, Cache<?, ?> cache) {
        StatisticsManager.associate(cache).withParent((Object)this.cacheManager);
        this.register(cache);
        this.register(new CacheBinding(alias, cache));
    }

    public void cacheRemoved(String alias, Cache<?, ?> cache) {
        this.unregister(cache);
        this.unregister(new CacheBinding(alias, cache));
        StatisticsManager.dissociate(cache).fromParent((Object)this.cacheManager);
    }

    public void stateTransition(Status from, Status to) {
        switch (to) {
            case AVAILABLE: {
                this.register(this.cacheManager);
                for (Map.Entry entry : this.cacheManager.getRuntimeConfiguration().getCacheConfigurations().entrySet()) {
                    String alias = (String)entry.getKey();
                    CacheConfiguration configuration = (CacheConfiguration)entry.getValue();
                    Cache cache = this.cacheManager.getCache(alias, configuration.getKeyType(), configuration.getValueType());
                    this.cacheAdded(alias, cache);
                }
                break;
            }
            case UNINITIALIZED: {
                this.cacheManager.deregisterListener((CacheManagerListener)this);
                break;
            }
            case MAINTENANCE: {
                break;
            }
            default: {
                throw new AssertionError(to);
            }
        }
    }

    @Override
    public ManagementRegistryServiceConfiguration getConfiguration() {
        return this.configuration;
    }

    public ContextContainer getContextContainer() {
        ArrayList<ContextContainer> cacheCtx = new ArrayList<ContextContainer>();
        for (String cacheName : this.cacheManager.getRuntimeConfiguration().getCacheConfigurations().keySet()) {
            cacheCtx.add(new ContextContainer("cacheName", cacheName));
        }
        return new ContextContainer("cacheManagerName", this.getConfiguration().getContext().get("cacheManagerName"), cacheCtx);
    }
}

