/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.management.providers.statistics;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.ehcache.core.statistics.CacheOperationOutcomes;
import org.terracotta.context.extended.OperationType;
import org.terracotta.context.query.Queries;
import org.terracotta.context.query.Query;

enum StandardOperationStatistic implements OperationType
{
    CACHE_LOADING(false, Queries.self(), CacheOperationOutcomes.CacheLoadingOutcome.class, "cacheLoading", "cache"),
    CACHE_GET(true, Queries.self(), CacheOperationOutcomes.GetOutcome.class, "get", "cache"),
    CACHE_PUT(true, Queries.self(), CacheOperationOutcomes.PutOutcome.class, "put", "cache"),
    CACHE_REMOVE(true, Queries.self(), CacheOperationOutcomes.RemoveOutcome.class, "remove", "cache"),
    CACHE_CONDITIONAL_REMOVE(true, Queries.self(), CacheOperationOutcomes.ConditionalRemoveOutcome.class, "conditionalRemove", "cache"),
    CACHE_PUT_IF_ABSENT(true, Queries.self(), CacheOperationOutcomes.PutIfAbsentOutcome.class, "putIfAbsent", "cache"),
    CACHE_REPLACE(true, Queries.self(), CacheOperationOutcomes.ReplaceOutcome.class, "replace", "cache");

    private final boolean required;
    private final Query context;
    private final Class<? extends Enum<?>> type;
    private final String name;
    private final Set<String> tags;

    private StandardOperationStatistic(boolean required, Query context, Class<? extends Enum<?>> type, String name, String ... tags) {
        this.required = required;
        this.context = context;
        this.type = type;
        this.name = name;
        this.tags = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(tags)));
    }

    public final boolean required() {
        return this.required;
    }

    public final Query context() {
        return this.context;
    }

    public final Class<? extends Enum<?>> type() {
        return this.type;
    }

    public final String operationName() {
        return this.name;
    }

    public final Set<String> tags() {
        return this.tags;
    }
}

