/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.management.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public abstract class ConversionHelper {
    private ConversionHelper() {
    }

    public static Object convert(Object srcObj, Class<?> destClazz) {
        if (srcObj == null || destClazz.isInstance(srcObj)) {
            return srcObj;
        }
        try {
            Constructor<?> constructor = destClazz.getConstructor(srcObj.getClass());
            return constructor.newInstance(srcObj);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("No conversion possible from " + srcObj.getClass().getName() + " to " + destClazz.getName(), e);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Conversion error from " + srcObj.getClass().getName() + " to " + destClazz.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

