/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.management.providers.statistics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import org.ehcache.Ehcache;
import org.ehcache.management.config.StatisticsProviderConfiguration;
import org.ehcache.management.providers.ManagementProvider;
import org.ehcache.management.providers.statistics.EhcacheStatistics;
import org.ehcache.management.utils.ContextHelper;
import org.ehcache.util.ConcurrentWeakIdentityHashMap;
import org.terracotta.management.capabilities.context.CapabilityContext;
import org.terracotta.management.capabilities.descriptors.Descriptor;
import org.terracotta.management.stats.Statistic;

public class EhcacheStatisticsProvider
implements ManagementProvider<Ehcache> {
    private final ConcurrentMap<Ehcache, EhcacheStatistics> statistics = new ConcurrentWeakIdentityHashMap();
    private final StatisticsProviderConfiguration configuration;
    private final ScheduledExecutorService executor;

    public EhcacheStatisticsProvider(StatisticsProviderConfiguration statisticsProviderConfiguration, ScheduledExecutorService executor) {
        this.configuration = statisticsProviderConfiguration;
        this.executor = executor;
    }

    public StatisticsProviderConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public void register(Ehcache ehcache) {
        this.statistics.putIfAbsent(ehcache, this.createStatistics(ehcache));
    }

    EhcacheStatistics createStatistics(Ehcache ehcache) {
        return new EhcacheStatistics(ehcache, this.configuration, this.executor);
    }

    @Override
    public void unregister(Ehcache ehcache) {
        EhcacheStatistics removed = (EhcacheStatistics)this.statistics.remove(ehcache);
        if (removed != null) {
            removed.dispose();
        }
    }

    @Override
    public Class<Ehcache> managedType() {
        return Ehcache.class;
    }

    @Override
    public Set<Descriptor> descriptions() {
        HashSet<Descriptor> capabilities = new HashSet<Descriptor>();
        for (EhcacheStatistics ehcacheStatistics : this.statistics.values()) {
            capabilities.addAll(ehcacheStatistics.capabilities());
        }
        return capabilities;
    }

    @Override
    public CapabilityContext capabilityContext() {
        return new CapabilityContext(Arrays.asList(new CapabilityContext.Attribute("cacheManagerName", true), new CapabilityContext.Attribute("cacheName", true)));
    }

    @Override
    public Collection<Statistic<?>> collectStatistics(Map<String, String> context, String ... statisticNames) {
        String cacheManagerName = context.get("cacheManagerName");
        if (cacheManagerName == null) {
            throw new IllegalArgumentException("Missing cache manager name from context");
        }
        String cacheName = context.get("cacheName");
        if (cacheName == null) {
            throw new IllegalArgumentException("Missing cache name from context");
        }
        for (Map.Entry entry : this.statistics.entrySet()) {
            if (!ContextHelper.findCacheManagerName((Ehcache)entry.getKey()).equals(cacheManagerName) || !ContextHelper.findCacheName((Ehcache)entry.getKey()).equals(cacheName)) continue;
            ArrayList result = new ArrayList();
            for (String statisticName : statisticNames) {
                result.addAll(((EhcacheStatistics)entry.getValue()).queryStatistic(statisticName));
            }
            return result;
        }
        throw new IllegalArgumentException("No such cache manager / cache pair : [" + cacheManagerName + " / " + cacheName + "]");
    }

    @Override
    public Object callAction(Map<String, String> context, String methodName, String[] argClassNames, Object[] args) {
        throw new UnsupportedOperationException("Not an action provider : " + this.getClass().getName());
    }
}

