/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.expiry;

import org.ehcache.ValueSupplier;
import org.ehcache.expiry.Duration;
import org.ehcache.expiry.Expiry;

public final class Expirations {
    public static Expiry<Object, Object> noExpiration() {
        return NoExpiry.INSTANCE;
    }

    public static Expiry<Object, Object> timeToLiveExpiration(Duration timeToLive) {
        if (timeToLive == null) {
            throw new NullPointerException("Duration cannot be null");
        }
        return new TimeToLiveExpiry(timeToLive);
    }

    public static Expiry<Object, Object> timeToIdleExpiration(Duration timeToIdle) {
        if (timeToIdle == null) {
            throw new NullPointerException("Duration cannot be null");
        }
        return new TimeToIdleExpiry(timeToIdle);
    }

    public static <K, V> ExpiryBuilder<K, V> builder() {
        return new ExpiryBuilder();
    }

    private Expirations() {
    }

    public static final class ExpiryBuilder<K, V> {
        private Duration create = Duration.INFINITE;
        private Duration access = null;
        private Duration update = null;

        private ExpiryBuilder() {
        }

        public ExpiryBuilder<K, V> setCreate(Duration create) {
            this.create = create;
            return this;
        }

        public ExpiryBuilder<K, V> setAccess(Duration access) {
            this.access = access;
            return this;
        }

        public ExpiryBuilder<K, V> setUpdate(Duration update) {
            this.update = update;
            return this;
        }

        public Expiry<K, V> build() {
            return new BaseExpiry(this.create, this.access, this.update);
        }
    }

    private static class NoExpiry
    extends BaseExpiry<Object, Object> {
        private static final Expiry<Object, Object> INSTANCE = new NoExpiry();

        private NoExpiry() {
            super(Duration.INFINITE, null, null);
        }
    }

    private static class TimeToIdleExpiry
    extends BaseExpiry<Object, Object> {
        TimeToIdleExpiry(Duration tti) {
            super(tti, tti, tti);
        }
    }

    private static class TimeToLiveExpiry
    extends BaseExpiry<Object, Object> {
        TimeToLiveExpiry(Duration ttl) {
            super(ttl, null, ttl);
        }
    }

    private static class BaseExpiry<K, V>
    implements Expiry<K, V> {
        private final Duration create;
        private final Duration access;
        private final Duration update;

        BaseExpiry(Duration create, Duration access, Duration update) {
            this.create = create;
            this.access = access;
            this.update = update;
        }

        @Override
        public Duration getExpiryForCreation(K key, V value) {
            return this.create;
        }

        @Override
        public Duration getExpiryForAccess(K key, ValueSupplier<? extends V> value) {
            return this.access;
        }

        @Override
        public Duration getExpiryForUpdate(K key, ValueSupplier<? extends V> oldValue, V newValue) {
            return this.update;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BaseExpiry that = (BaseExpiry)o;
            if (this.access != null ? !this.access.equals(that.access) : that.access != null) {
                return false;
            }
            if (this.create != null ? !this.create.equals(that.create) : that.create != null) {
                return false;
            }
            return !(this.update != null ? !this.update.equals(that.update) : that.update != null);
        }

        public int hashCode() {
            int result = this.create != null ? this.create.hashCode() : 0;
            result = 31 * result + (this.access != null ? this.access.hashCode() : 0);
            result = 31 * result + (this.update != null ? this.update.hashCode() : 0);
            return result;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{create=" + this.create + ", access=" + this.access + ", update=" + this.update + '}';
        }
    }
}

