/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.jsr107;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import javax.cache.management.CacheStatisticsMXBean;
import org.ehcache.Cache;
import org.ehcache.core.InternalCache;
import org.ehcache.core.statistics.BulkOps;
import org.ehcache.core.statistics.CacheOperationOutcomes;
import org.ehcache.core.statistics.StoreOperationOutcomes;
import org.ehcache.jsr107.Eh107CacheManager;
import org.ehcache.jsr107.Eh107MXBean;
import org.terracotta.context.ContextManager;
import org.terracotta.context.TreeNode;
import org.terracotta.context.query.Matcher;
import org.terracotta.context.query.Matchers;
import org.terracotta.context.query.Query;
import org.terracotta.context.query.QueryBuilder;
import org.terracotta.statistics.OperationStatistic;
import org.terracotta.statistics.derived.LatencySampling;
import org.terracotta.statistics.derived.MinMaxAverage;
import org.terracotta.statistics.jsr166e.LongAdder;
import org.terracotta.statistics.observer.ChainedObserver;
import org.terracotta.statistics.observer.ChainedOperationObserver;

class Eh107CacheStatisticsMXBean
extends Eh107MXBean
implements CacheStatisticsMXBean {
    private final CompensatingCounters compensatingCounters = new CompensatingCounters();
    private final OperationStatistic<CacheOperationOutcomes.GetOutcome> get;
    private final OperationStatistic<CacheOperationOutcomes.PutOutcome> put;
    private final OperationStatistic<CacheOperationOutcomes.RemoveOutcome> remove;
    private final OperationStatistic<CacheOperationOutcomes.PutIfAbsentOutcome> putIfAbsent;
    private final OperationStatistic<CacheOperationOutcomes.ReplaceOutcome> replace;
    private final OperationStatistic<CacheOperationOutcomes.ConditionalRemoveOutcome> conditionalRemove;
    private final OperationStatistic<StoreOperationOutcomes.EvictionOutcome> lowestTierEviction;
    private final Map<BulkOps, LongAdder> bulkMethodEntries;
    private final LatencyMonitor<CacheOperationOutcomes.GetOutcome> averageGetTime;
    private final LatencyMonitor<CacheOperationOutcomes.PutOutcome> averagePutTime;
    private final LatencyMonitor<CacheOperationOutcomes.RemoveOutcome> averageRemoveTime;

    Eh107CacheStatisticsMXBean(String cacheName, Eh107CacheManager cacheManager, InternalCache<?, ?> cache) {
        super(cacheName, cacheManager, "CacheStatistics");
        this.bulkMethodEntries = cache.getBulkMethodEntries();
        this.get = Eh107CacheStatisticsMXBean.findCacheStatistic(cache, CacheOperationOutcomes.GetOutcome.class, "get");
        this.put = Eh107CacheStatisticsMXBean.findCacheStatistic(cache, CacheOperationOutcomes.PutOutcome.class, "put");
        this.remove = Eh107CacheStatisticsMXBean.findCacheStatistic(cache, CacheOperationOutcomes.RemoveOutcome.class, "remove");
        this.putIfAbsent = Eh107CacheStatisticsMXBean.findCacheStatistic(cache, CacheOperationOutcomes.PutIfAbsentOutcome.class, "putIfAbsent");
        this.replace = Eh107CacheStatisticsMXBean.findCacheStatistic(cache, CacheOperationOutcomes.ReplaceOutcome.class, "replace");
        this.conditionalRemove = Eh107CacheStatisticsMXBean.findCacheStatistic(cache, CacheOperationOutcomes.ConditionalRemoveOutcome.class, "conditionalRemove");
        this.lowestTierEviction = this.findLowestTierStatistic((Cache<?, ?>)cache, (Class)StoreOperationOutcomes.EvictionOutcome.class, "eviction");
        this.averageGetTime = new LatencyMonitor<CacheOperationOutcomes.GetOutcome>(EnumSet.allOf(CacheOperationOutcomes.GetOutcome.class));
        this.get.addDerivedStatistic(this.averageGetTime);
        this.averagePutTime = new LatencyMonitor<CacheOperationOutcomes.PutOutcome>(EnumSet.allOf(CacheOperationOutcomes.PutOutcome.class));
        this.put.addDerivedStatistic(this.averagePutTime);
        this.averageRemoveTime = new LatencyMonitor<CacheOperationOutcomes.RemoveOutcome>(EnumSet.allOf(CacheOperationOutcomes.RemoveOutcome.class));
        this.remove.addDerivedStatistic(this.averageRemoveTime);
    }

    public void clear() {
        this.compensatingCounters.snapshot();
        this.averageGetTime.clear();
        this.averagePutTime.clear();
        this.averageRemoveTime.clear();
    }

    public long getCacheHits() {
        return Eh107CacheStatisticsMXBean.normalize(this.getHits() - this.compensatingCounters.cacheHits - this.compensatingCounters.bulkGetHits);
    }

    public float getCacheHitPercentage() {
        long cacheHits = this.getCacheHits();
        return Eh107CacheStatisticsMXBean.normalize((float)cacheHits / (float)(cacheHits + this.getCacheMisses())) * 100.0f;
    }

    public long getCacheMisses() {
        return Eh107CacheStatisticsMXBean.normalize(this.getMisses() - this.compensatingCounters.cacheMisses - this.compensatingCounters.bulkGetMiss);
    }

    public float getCacheMissPercentage() {
        long cacheMisses = this.getCacheMisses();
        return Eh107CacheStatisticsMXBean.normalize((float)cacheMisses / (float)(this.getCacheHits() + cacheMisses)) * 100.0f;
    }

    public long getCacheGets() {
        return Eh107CacheStatisticsMXBean.normalize(this.getHits() + this.getMisses() - this.compensatingCounters.cacheGets - this.compensatingCounters.bulkGetHits - this.compensatingCounters.bulkGetMiss);
    }

    public long getCachePuts() {
        return Eh107CacheStatisticsMXBean.normalize(this.getBulkCount(BulkOps.PUT_ALL) - this.compensatingCounters.bulkPuts + this.put.sum(EnumSet.of(CacheOperationOutcomes.PutOutcome.PUT)) + this.put.sum(EnumSet.of(CacheOperationOutcomes.PutOutcome.UPDATED)) + this.putIfAbsent.sum(EnumSet.of(CacheOperationOutcomes.PutIfAbsentOutcome.PUT)) + this.replace.sum(EnumSet.of(CacheOperationOutcomes.ReplaceOutcome.HIT)) - this.compensatingCounters.cachePuts);
    }

    public long getCacheRemovals() {
        return Eh107CacheStatisticsMXBean.normalize(this.getBulkCount(BulkOps.REMOVE_ALL) - this.compensatingCounters.bulkRemovals + this.remove.sum(EnumSet.of(CacheOperationOutcomes.RemoveOutcome.SUCCESS)) + this.conditionalRemove.sum(EnumSet.of(CacheOperationOutcomes.ConditionalRemoveOutcome.SUCCESS)) - this.compensatingCounters.cacheRemovals);
    }

    public long getCacheEvictions() {
        return Eh107CacheStatisticsMXBean.normalize(this.lowestTierEviction.sum(EnumSet.of(StoreOperationOutcomes.EvictionOutcome.SUCCESS)) - this.compensatingCounters.cacheEvictions);
    }

    public float getAverageGetTime() {
        return (float)this.averageGetTime.value();
    }

    public float getAveragePutTime() {
        return (float)this.averagePutTime.value();
    }

    public float getAverageRemoveTime() {
        return (float)this.averageRemoveTime.value();
    }

    private long getMisses() {
        return this.getBulkCount(BulkOps.GET_ALL_MISS) + this.get.sum(EnumSet.of(CacheOperationOutcomes.GetOutcome.MISS_NO_LOADER, CacheOperationOutcomes.GetOutcome.MISS_WITH_LOADER)) + this.putIfAbsent.sum(EnumSet.of(CacheOperationOutcomes.PutIfAbsentOutcome.PUT)) + this.replace.sum(EnumSet.of(CacheOperationOutcomes.ReplaceOutcome.MISS_NOT_PRESENT)) + this.conditionalRemove.sum(EnumSet.of(CacheOperationOutcomes.ConditionalRemoveOutcome.FAILURE_KEY_MISSING));
    }

    private long getHits() {
        return this.getBulkCount(BulkOps.GET_ALL_HITS) + this.get.sum(EnumSet.of(CacheOperationOutcomes.GetOutcome.HIT_NO_LOADER, CacheOperationOutcomes.GetOutcome.HIT_WITH_LOADER)) + this.putIfAbsent.sum(EnumSet.of(CacheOperationOutcomes.PutIfAbsentOutcome.PUT)) + this.replace.sum(EnumSet.of(CacheOperationOutcomes.ReplaceOutcome.HIT, CacheOperationOutcomes.ReplaceOutcome.MISS_PRESENT)) + this.conditionalRemove.sum(EnumSet.of(CacheOperationOutcomes.ConditionalRemoveOutcome.SUCCESS, CacheOperationOutcomes.ConditionalRemoveOutcome.FAILURE_KEY_PRESENT));
    }

    private long getBulkCount(BulkOps bulkOps) {
        return this.bulkMethodEntries.get(bulkOps).longValue();
    }

    private static long normalize(long value) {
        return Math.max(0L, value);
    }

    private static float normalize(float value) {
        if (Float.isNaN(value)) {
            return 0.0f;
        }
        return Math.min(1.0f, Math.max(0.0f, value));
    }

    static <T extends Enum<T>> OperationStatistic<T> findCacheStatistic(Cache<?, ?> cache, Class<T> type, String statName) {
        Query query = QueryBuilder.queryBuilder().children().filter(Matchers.context((Matcher)Matchers.attributes((Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.hasAttribute((String)"name", (Object)statName), Matchers.hasAttribute((String)"type", type)})))).build();
        Set result = query.execute(Collections.singleton(ContextManager.nodeFor(cache)));
        if (result.size() > 1) {
            throw new RuntimeException("result must be unique");
        }
        if (result.isEmpty()) {
            throw new RuntimeException("result must not be null");
        }
        return (OperationStatistic)((TreeNode)result.iterator().next()).getContext().attributes().get("this");
    }

    <T extends Enum<T>> OperationStatistic<T> findLowestTierStatistic(Cache<?, ?> cache, Class<T> type, String statName) {
        Query statQuery = QueryBuilder.queryBuilder().descendants().filter(Matchers.context((Matcher)Matchers.attributes((Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.hasAttribute((String)"name", (Object)statName), Matchers.hasAttribute((String)"type", type)})))).build();
        Set statResult = statQuery.execute(Collections.singleton(ContextManager.nodeFor(cache)));
        if (statResult.size() < 1) {
            throw new RuntimeException("Failed to find lowest tier statistic: " + statName + " , valid result Set sizes must 1 or more.  Found result Set size of: " + statResult.size());
        }
        if (statResult.size() == 1) {
            return (OperationStatistic)((TreeNode)statResult.iterator().next()).getContext().attributes().get("this");
        }
        String lowestStoreType = "onheap";
        TreeNode lowestTierNode = null;
        for (TreeNode treeNode : statResult) {
            if (((Set)treeNode.getContext().attributes().get("tags")).size() != 1) {
                throw new RuntimeException("Failed to find lowest tier statistic. \"tags\" set must be size 1");
            }
            String storeType = treeNode.getContext().attributes().get("tags").toString();
            if (storeType.compareToIgnoreCase(lowestStoreType) >= 0) continue;
            lowestStoreType = treeNode.getContext().attributes().get("tags").toString();
            lowestTierNode = treeNode;
        }
        return (OperationStatistic)lowestTierNode.getContext().attributes().get("this");
    }

    private static class LatencyMonitor<T extends Enum<T>>
    implements ChainedOperationObserver<T> {
        private final LatencySampling<T> sampling;
        private volatile MinMaxAverage average;

        public LatencyMonitor(Set<T> targets) {
            this.sampling = new LatencySampling(targets, 1.0);
            this.average = new MinMaxAverage();
            this.sampling.addDerivedStatistic((ChainedObserver)this.average);
        }

        public void begin(long time) {
            this.sampling.begin(time);
        }

        public void end(long time, T result) {
            this.sampling.end(time, result);
        }

        public void end(long time, T result, long ... parameters) {
            this.sampling.end(time, result, parameters);
        }

        public double value() {
            Double value = this.average.mean();
            if (value == null) {
                return 0.0;
            }
            return value / 1000.0;
        }

        public synchronized void clear() {
            this.sampling.removeDerivedStatistic((ChainedObserver)this.average);
            this.average = new MinMaxAverage();
            this.sampling.addDerivedStatistic((ChainedObserver)this.average);
        }
    }

    class CompensatingCounters {
        volatile long cacheHits;
        volatile long cacheMisses;
        volatile long cacheGets;
        volatile long bulkGetHits;
        volatile long bulkGetMiss;
        volatile long cachePuts;
        volatile long bulkPuts;
        volatile long cacheRemovals;
        volatile long bulkRemovals;
        volatile long cacheEvictions;

        CompensatingCounters() {
        }

        void snapshot() {
            this.cacheHits += Eh107CacheStatisticsMXBean.this.getCacheHits();
            this.cacheMisses += Eh107CacheStatisticsMXBean.this.getCacheMisses();
            this.cacheGets += Eh107CacheStatisticsMXBean.this.getCacheGets();
            this.bulkGetHits += Eh107CacheStatisticsMXBean.this.getBulkCount(BulkOps.GET_ALL_HITS);
            this.bulkGetMiss += Eh107CacheStatisticsMXBean.this.getBulkCount(BulkOps.GET_ALL_MISS);
            this.cachePuts += Eh107CacheStatisticsMXBean.this.getCachePuts();
            this.bulkPuts += Eh107CacheStatisticsMXBean.this.getBulkCount(BulkOps.PUT_ALL);
            this.cacheRemovals += Eh107CacheStatisticsMXBean.this.getCacheRemovals();
            this.bulkRemovals += Eh107CacheStatisticsMXBean.this.getBulkCount(BulkOps.REMOVE_ALL);
            this.cacheEvictions += Eh107CacheStatisticsMXBean.this.getCacheEvictions();
        }
    }
}

