/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.jsr107;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.cache.CacheException;
import javax.cache.CacheManager;
import javax.cache.configuration.OptionalFeature;
import javax.cache.spi.CachingProvider;
import org.ehcache.config.Configuration;
import org.ehcache.core.EhcacheManager;
import org.ehcache.core.config.DefaultConfiguration;
import org.ehcache.core.internal.util.ClassLoading;
import org.ehcache.core.spi.ServiceLocator;
import org.ehcache.impl.config.serializer.DefaultSerializationProviderConfiguration;
import org.ehcache.jsr107.ConfigurationMerger;
import org.ehcache.jsr107.DefaultConfigurationResolver;
import org.ehcache.jsr107.DefaultJsr107SerializationProvider;
import org.ehcache.jsr107.DefaultJsr107Service;
import org.ehcache.jsr107.Eh107CacheLoaderWriterProvider;
import org.ehcache.jsr107.Eh107CacheManager;
import org.ehcache.jsr107.MultiCacheException;
import org.ehcache.jsr107.config.Jsr107Configuration;
import org.ehcache.management.ManagementRegistryService;
import org.ehcache.spi.ServiceProvider;
import org.ehcache.spi.service.Service;
import org.ehcache.spi.service.ServiceDependencies;
import org.ehcache.xml.XmlConfiguration;

public class EhcacheCachingProvider
implements CachingProvider {
    private static final String DEFAULT_URI_STRING = "urn:X-ehcache:jsr107-default-config";
    private static final URI URI_DEFAULT;
    private final Map<ClassLoader, ConcurrentMap<URI, Eh107CacheManager>> cacheManagers = new WeakHashMap<ClassLoader, ConcurrentMap<URI, Eh107CacheManager>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheManager getCacheManager(URI uri, ClassLoader classLoader, Properties properties) {
        Eh107CacheManager cacheManager;
        URI override;
        uri = uri == null ? this.getDefaultURI() : uri;
        classLoader = classLoader == null ? this.getDefaultClassLoader() : classLoader;
        Properties properties2 = properties = properties == null ? new Properties() : EhcacheCachingProvider.cloneProperties(properties);
        if (URI_DEFAULT.equals(uri) && (override = DefaultConfigurationResolver.resolveConfigURI(properties)) != null) {
            uri = override;
        }
        Map<ClassLoader, ConcurrentMap<URI, Eh107CacheManager>> map = this.cacheManagers;
        synchronized (map) {
            ConcurrentMap<URI, Eh107CacheManager> byURI = this.cacheManagers.get(classLoader);
            if (byURI == null) {
                byURI = new ConcurrentHashMap<URI, Eh107CacheManager>();
                this.cacheManagers.put(classLoader, byURI);
            }
            if ((cacheManager = (Eh107CacheManager)byURI.get(uri)) == null || cacheManager.isClosed()) {
                Object config;
                if (cacheManager != null) {
                    byURI.remove(uri, cacheManager);
                }
                try {
                    config = URI_DEFAULT.equals(uri) ? new DefaultConfiguration(classLoader) : new XmlConfiguration(uri.toURL(), classLoader);
                }
                catch (Exception e) {
                    throw new CacheException((Throwable)e);
                }
                Eh107CacheLoaderWriterProvider cacheLoaderWriterFactory = new Eh107CacheLoaderWriterProvider();
                DefaultJsr107Service jsr107Service = new DefaultJsr107Service((Jsr107Configuration)ServiceLocator.findSingletonAmongst(Jsr107Configuration.class, (Object[])config.getServiceCreationConfigurations().toArray()));
                ManagementRegistryCollectorService managementRegistryCollectorService = new ManagementRegistryCollectorService();
                ArrayList<Object> services = new ArrayList<Object>();
                services.add((Object)cacheLoaderWriterFactory);
                services.add(jsr107Service);
                if (ServiceLocator.findSingletonAmongst(DefaultSerializationProviderConfiguration.class, (Object[])config.getServiceCreationConfigurations().toArray()) == null) {
                    services.add((Object)new DefaultJsr107SerializationProvider());
                }
                services.add(managementRegistryCollectorService);
                EhcacheManager ehcacheManager = new EhcacheManager((Configuration)config, services, !jsr107Service.jsr107CompliantAtomics());
                ehcacheManager.init();
                cacheManager = new Eh107CacheManager(this, ehcacheManager, properties, classLoader, uri, managementRegistryCollectorService.managementRegistry, new ConfigurationMerger((Configuration)config, jsr107Service, cacheLoaderWriterFactory));
                byURI.put(uri, cacheManager);
            }
        }
        return cacheManager;
    }

    public ClassLoader getDefaultClassLoader() {
        return ClassLoading.getDefaultClassLoader();
    }

    public URI getDefaultURI() {
        return URI_DEFAULT;
    }

    public Properties getDefaultProperties() {
        return new Properties();
    }

    public CacheManager getCacheManager(URI uri, ClassLoader classLoader) {
        return this.getCacheManager(uri, classLoader, null);
    }

    public CacheManager getCacheManager() {
        return this.getCacheManager(this.getDefaultURI(), this.getDefaultClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Map<ClassLoader, ConcurrentMap<URI, Eh107CacheManager>> map = this.cacheManagers;
        synchronized (map) {
            for (Map.Entry<ClassLoader, ConcurrentMap<URI, Eh107CacheManager>> entry : this.cacheManagers.entrySet()) {
                for (Eh107CacheManager cacheManager : entry.getValue().values()) {
                    cacheManager.close();
                }
            }
            this.cacheManagers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(ClassLoader classLoader) {
        if (classLoader == null) {
            throw new NullPointerException();
        }
        MultiCacheException closeException = new MultiCacheException();
        Map<ClassLoader, ConcurrentMap<URI, Eh107CacheManager>> map = this.cacheManagers;
        synchronized (map) {
            ConcurrentMap<URI, Eh107CacheManager> map2 = this.cacheManagers.remove(classLoader);
            if (map2 != null) {
                for (Eh107CacheManager cacheManager : map2.values()) {
                    cacheManager.closeInternal(closeException);
                }
            }
        }
        closeException.throwIfNotEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(URI uri, ClassLoader classLoader) {
        if (uri == null || classLoader == null) {
            throw new NullPointerException();
        }
        MultiCacheException closeException = new MultiCacheException();
        Map<ClassLoader, ConcurrentMap<URI, Eh107CacheManager>> map = this.cacheManagers;
        synchronized (map) {
            Eh107CacheManager cacheManager;
            ConcurrentMap<URI, Eh107CacheManager> map2 = this.cacheManagers.get(classLoader);
            if (map2 != null && (cacheManager = (Eh107CacheManager)map2.remove(uri)) != null) {
                cacheManager.closeInternal(closeException);
            }
        }
        closeException.throwIfNotEmpty();
    }

    public boolean isSupported(OptionalFeature optionalFeature) {
        if (optionalFeature == null) {
            throw new NullPointerException();
        }
        switch (optionalFeature) {
            case STORE_BY_REFERENCE: {
                return true;
            }
        }
        throw new IllegalArgumentException("Unknown OptionalFeature: " + optionalFeature.name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(Eh107CacheManager cacheManager, MultiCacheException closeException) {
        try {
            Map<ClassLoader, ConcurrentMap<URI, Eh107CacheManager>> map = this.cacheManagers;
            synchronized (map) {
                ConcurrentMap<URI, Eh107CacheManager> map2 = this.cacheManagers.get(cacheManager.getClassLoader());
                if (map2 != null && map2.remove(cacheManager.getURI()) != null) {
                    cacheManager.closeInternal(closeException);
                }
            }
        }
        catch (Throwable t) {
            closeException.addThrowable(t);
        }
    }

    private static Properties cloneProperties(Properties properties) {
        Properties clone = new Properties();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            clone.put(entry.getKey(), entry.getValue());
        }
        return clone;
    }

    static {
        try {
            URI_DEFAULT = new URI(DEFAULT_URI_STRING);
        }
        catch (URISyntaxException e) {
            throw new CacheException((Throwable)e);
        }
    }

    @ServiceDependencies(value={ManagementRegistryService.class})
    static class ManagementRegistryCollectorService
    implements Service {
        public volatile ManagementRegistryService managementRegistry;

        ManagementRegistryCollectorService() {
        }

        public void start(ServiceProvider<Service> serviceProvider) {
            this.managementRegistry = (ManagementRegistryService)serviceProvider.getService(ManagementRegistryService.class);
        }

        public void stop() {
            this.managementRegistry = null;
        }
    }
}

