/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.jsr107;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.cache.management.CacheStatisticsMXBean;
import org.ehcache.Cache;
import org.ehcache.Ehcache;
import org.ehcache.EhcacheHackAccessor;
import org.ehcache.jsr107.Eh107CacheManager;
import org.ehcache.jsr107.Eh107MXBean;
import org.ehcache.management.ManagementRegistry;
import org.ehcache.management.StatisticQuery;
import org.ehcache.statistics.BulkOps;
import org.ehcache.statistics.CacheOperationOutcomes;
import org.ehcache.statistics.StoreOperationOutcomes;
import org.terracotta.context.ContextManager;
import org.terracotta.context.TreeNode;
import org.terracotta.context.query.Matcher;
import org.terracotta.context.query.Matchers;
import org.terracotta.context.query.Query;
import org.terracotta.context.query.QueryBuilder;
import org.terracotta.management.context.Context;
import org.terracotta.management.stats.ContextualStatistics;
import org.terracotta.management.stats.Sample;
import org.terracotta.management.stats.StatisticHistory;
import org.terracotta.management.stats.history.AverageHistory;
import org.terracotta.statistics.OperationStatistic;
import org.terracotta.statistics.StatisticsManager;
import org.terracotta.statistics.jsr166e.LongAdder;

public class Eh107CacheStatisticsMXBean
extends Eh107MXBean
implements CacheStatisticsMXBean {
    private final CompensatingCounters compensatingCounters = new CompensatingCounters();
    private final OperationStatistic<CacheOperationOutcomes.GetOutcome> get;
    private final OperationStatistic<CacheOperationOutcomes.PutOutcome> put;
    private final OperationStatistic<CacheOperationOutcomes.RemoveOutcome> remove;
    private final OperationStatistic<CacheOperationOutcomes.PutIfAbsentOutcome> putIfAbsent;
    private final OperationStatistic<CacheOperationOutcomes.ReplaceOutcome> replace;
    private final OperationStatistic<CacheOperationOutcomes.ConditionalRemoveOutcome> conditionalRemove;
    private final OperationStatistic<StoreOperationOutcomes.EvictionOutcome> authorityEviction;
    private final Map<BulkOps, LongAdder> bulkMethodEntries;
    private final StatisticQuery averageGetTime;
    private final StatisticQuery averagePutTime;
    private final StatisticQuery averageRemoveTime;

    Eh107CacheStatisticsMXBean(String cacheName, Eh107CacheManager cacheManager, Cache<?, ?> cache, ManagementRegistry managementRegistry) {
        super(cacheName, cacheManager, "CacheStatistics");
        this.bulkMethodEntries = EhcacheHackAccessor.getBulkMethodEntries((Ehcache)cache);
        this.get = Eh107CacheStatisticsMXBean.findCacheStatistic(cache, CacheOperationOutcomes.GetOutcome.class, "get");
        this.put = Eh107CacheStatisticsMXBean.findCacheStatistic(cache, CacheOperationOutcomes.PutOutcome.class, "put");
        this.remove = Eh107CacheStatisticsMXBean.findCacheStatistic(cache, CacheOperationOutcomes.RemoveOutcome.class, "remove");
        this.putIfAbsent = Eh107CacheStatisticsMXBean.findCacheStatistic(cache, CacheOperationOutcomes.PutIfAbsentOutcome.class, "putIfAbsent");
        this.replace = Eh107CacheStatisticsMXBean.findCacheStatistic(cache, CacheOperationOutcomes.ReplaceOutcome.class, "replace");
        this.conditionalRemove = Eh107CacheStatisticsMXBean.findCacheStatistic(cache, CacheOperationOutcomes.ConditionalRemoveOutcome.class, "conditionalRemove");
        this.authorityEviction = this.findAuthoritativeTierStatistic(cache, StoreOperationOutcomes.EvictionOutcome.class, "eviction");
        Context context = Context.create().with("cacheManagerName", managementRegistry.getConfiguration().getCacheManagerAlias()).with("cacheName", cacheName);
        this.averageGetTime = (StatisticQuery)((StatisticQuery.Builder)managementRegistry.withCapability("StatisticsCapability").queryStatistic("AllCacheGetLatencyAverage").on(context)).build();
        this.averagePutTime = (StatisticQuery)((StatisticQuery.Builder)managementRegistry.withCapability("StatisticsCapability").queryStatistic("AllCachePutLatencyAverage").on(context)).build();
        this.averageRemoveTime = (StatisticQuery)((StatisticQuery.Builder)managementRegistry.withCapability("StatisticsCapability").queryStatistic("AllCacheRemoveLatencyAverage").on(context)).build();
    }

    public void clear() {
        this.compensatingCounters.snapshot();
    }

    public long getCacheHits() {
        return Eh107CacheStatisticsMXBean.normalize(this.getHits() - this.compensatingCounters.cacheHits - this.compensatingCounters.bulkGetHits);
    }

    public float getCacheHitPercentage() {
        long cacheHits = this.getCacheHits();
        return Eh107CacheStatisticsMXBean.normalize((float)cacheHits / (float)(cacheHits + this.getCacheMisses())) * 100.0f;
    }

    public long getCacheMisses() {
        return Eh107CacheStatisticsMXBean.normalize(this.getMisses() - this.compensatingCounters.cacheMisses - this.compensatingCounters.bulkGetMiss);
    }

    public float getCacheMissPercentage() {
        long cacheMisses = this.getCacheMisses();
        return Eh107CacheStatisticsMXBean.normalize((float)cacheMisses / (float)(this.getCacheHits() + cacheMisses)) * 100.0f;
    }

    public long getCacheGets() {
        return Eh107CacheStatisticsMXBean.normalize(this.getHits() + this.getMisses() - this.compensatingCounters.cacheGets - this.compensatingCounters.bulkGetHits - this.compensatingCounters.bulkGetMiss);
    }

    public long getCachePuts() {
        return Eh107CacheStatisticsMXBean.normalize(this.getBulkCount(BulkOps.PUT_ALL) - this.compensatingCounters.bulkPuts + this.put.sum(EnumSet.of(CacheOperationOutcomes.PutOutcome.ADDED)) + this.putIfAbsent.sum(EnumSet.of(CacheOperationOutcomes.PutIfAbsentOutcome.PUT)) + this.replace.sum(EnumSet.of(CacheOperationOutcomes.ReplaceOutcome.HIT)) - this.compensatingCounters.cachePuts);
    }

    public long getCacheRemovals() {
        return Eh107CacheStatisticsMXBean.normalize(this.getBulkCount(BulkOps.REMOVE_ALL) - this.compensatingCounters.bulkRemovals + this.remove.sum(EnumSet.of(CacheOperationOutcomes.RemoveOutcome.SUCCESS)) + this.conditionalRemove.sum(EnumSet.of(CacheOperationOutcomes.ConditionalRemoveOutcome.SUCCESS)) - this.compensatingCounters.cacheRemovals);
    }

    public long getCacheEvictions() {
        return Eh107CacheStatisticsMXBean.normalize(this.authorityEviction.sum(EnumSet.of(StoreOperationOutcomes.EvictionOutcome.SUCCESS)) - this.compensatingCounters.cacheEvictions);
    }

    public float getAverageGetTime() {
        return this.getMostRecentNotClearedValue((StatisticHistory)((ContextualStatistics)this.averageGetTime.execute().getSingleResult()).getStatistic(AverageHistory.class));
    }

    public float getAveragePutTime() {
        return this.getMostRecentNotClearedValue((StatisticHistory)((ContextualStatistics)this.averagePutTime.execute().getSingleResult()).getStatistic(AverageHistory.class));
    }

    public float getAverageRemoveTime() {
        return this.getMostRecentNotClearedValue((StatisticHistory)((ContextualStatistics)this.averageRemoveTime.execute().getSingleResult()).getStatistic(AverageHistory.class));
    }

    private float getMostRecentNotClearedValue(StatisticHistory<Double, ?> ratio) {
        List samples = (List)ratio.getValue();
        for (int i = samples.size() - 1; i >= 0; --i) {
            Sample doubleSample = (Sample)samples.get(i);
            if (doubleSample.getTimestamp() < this.compensatingCounters.timestamp) continue;
            return (float)((Double)doubleSample.getValue() / 1000.0);
        }
        return 0.0f;
    }

    private long getMisses() {
        return this.getBulkCount(BulkOps.GET_ALL_MISS) + this.get.sum(EnumSet.of(CacheOperationOutcomes.GetOutcome.MISS_NO_LOADER, CacheOperationOutcomes.GetOutcome.MISS_WITH_LOADER)) + this.putIfAbsent.sum(EnumSet.of(CacheOperationOutcomes.PutIfAbsentOutcome.PUT)) + this.replace.sum(EnumSet.of(CacheOperationOutcomes.ReplaceOutcome.MISS_NOT_PRESENT)) + this.conditionalRemove.sum(EnumSet.of(CacheOperationOutcomes.ConditionalRemoveOutcome.FAILURE_KEY_MISSING));
    }

    private long getHits() {
        return this.getBulkCount(BulkOps.GET_ALL_HITS) + this.get.sum(EnumSet.of(CacheOperationOutcomes.GetOutcome.HIT_NO_LOADER, CacheOperationOutcomes.GetOutcome.HIT_WITH_LOADER)) + this.putIfAbsent.sum(EnumSet.of(CacheOperationOutcomes.PutIfAbsentOutcome.PUT)) + this.replace.sum(EnumSet.of(CacheOperationOutcomes.ReplaceOutcome.HIT, CacheOperationOutcomes.ReplaceOutcome.MISS_PRESENT)) + this.conditionalRemove.sum(EnumSet.of(CacheOperationOutcomes.ConditionalRemoveOutcome.SUCCESS, CacheOperationOutcomes.ConditionalRemoveOutcome.FAILURE_KEY_PRESENT));
    }

    private long getBulkCount(BulkOps bulkOps) {
        return this.bulkMethodEntries.get(bulkOps).longValue();
    }

    private static long normalize(long value) {
        return Math.max(0L, value);
    }

    private static float normalize(float value) {
        if (Float.isNaN(value)) {
            return 0.0f;
        }
        return Math.min(1.0f, Math.max(0.0f, value));
    }

    static <T extends Enum<T>> OperationStatistic<T> findCacheStatistic(Cache<?, ?> cache, Class<T> type, String statName) {
        Query query = QueryBuilder.queryBuilder().children().filter(Matchers.context((Matcher)Matchers.attributes((Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.hasAttribute((String)"name", (Object)statName), Matchers.hasAttribute((String)"type", type)})))).build();
        Set result = query.execute(Collections.singleton(ContextManager.nodeFor(cache)));
        if (result.size() > 1) {
            throw new RuntimeException("result must be unique");
        }
        if (result.isEmpty()) {
            throw new RuntimeException("result must not be null");
        }
        return (OperationStatistic)((TreeNode)result.iterator().next()).getContext().attributes().get("this");
    }

    <T extends Enum<T>> OperationStatistic<T> findAuthoritativeTierStatistic(Cache<?, ?> cache, Class<T> type, String statName) {
        Query storeQuery = QueryBuilder.queryBuilder().children().children().filter(Matchers.context((Matcher)Matchers.attributes((Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.hasAttribute((String)"tags", (Matcher)new Matcher<Set<String>>(){

            protected boolean matchesSafely(Set<String> object) {
                return object.containsAll(Collections.singleton("store"));
            }
        })})))).build();
        Set storeResult = storeQuery.execute(Collections.singleton(ContextManager.nodeFor(cache)));
        if (storeResult.size() > 1) {
            throw new RuntimeException("store result must be unique");
        }
        if (storeResult.isEmpty()) {
            throw new RuntimeException("store result must not be null");
        }
        Object authoritativeTier = ((TreeNode)storeResult.iterator().next()).getContext().attributes().get("authoritativeTier");
        Query statQuery = QueryBuilder.queryBuilder().children().filter(Matchers.context((Matcher)Matchers.attributes((Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.hasAttribute((String)"name", (Object)statName), Matchers.hasAttribute((String)"type", type)})))).build();
        Set statResult = statQuery.execute(Collections.singleton(StatisticsManager.nodeFor(authoritativeTier)));
        if (statResult.size() > 1) {
            throw new RuntimeException("stat result must be unique");
        }
        if (statResult.isEmpty()) {
            throw new RuntimeException("stat result must not be null");
        }
        return (OperationStatistic)((TreeNode)statResult.iterator().next()).getContext().attributes().get("this");
    }

    class CompensatingCounters {
        volatile long cacheHits;
        volatile long cacheMisses;
        volatile long cacheGets;
        volatile long bulkGetHits;
        volatile long bulkGetMiss;
        volatile long cachePuts;
        volatile long bulkPuts;
        volatile long cacheRemovals;
        volatile long bulkRemovals;
        volatile long cacheEvictions;
        volatile long timestamp;

        CompensatingCounters() {
        }

        void snapshot() {
            this.cacheHits += Eh107CacheStatisticsMXBean.this.getCacheHits();
            this.cacheMisses += Eh107CacheStatisticsMXBean.this.getCacheMisses();
            this.cacheGets += Eh107CacheStatisticsMXBean.this.getCacheGets();
            this.bulkGetHits += Eh107CacheStatisticsMXBean.this.getBulkCount(BulkOps.GET_ALL_HITS);
            this.bulkGetMiss += Eh107CacheStatisticsMXBean.this.getBulkCount(BulkOps.GET_ALL_MISS);
            this.cachePuts += Eh107CacheStatisticsMXBean.this.getCachePuts();
            this.bulkPuts += Eh107CacheStatisticsMXBean.this.getBulkCount(BulkOps.PUT_ALL);
            this.cacheRemovals += Eh107CacheStatisticsMXBean.this.getCacheRemovals();
            this.bulkRemovals += Eh107CacheStatisticsMXBean.this.getBulkCount(BulkOps.REMOVE_ALL);
            this.cacheEvictions += Eh107CacheStatisticsMXBean.this.getCacheEvictions();
            this.timestamp = System.currentTimeMillis();
        }
    }
}

