/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.server.state;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.ehcache.clustered.server.state.InvalidationTracker;

public class InvalidationTrackerImpl
implements InvalidationTracker {
    private final ConcurrentMap<Long, Integer> invalidationMap = new ConcurrentHashMap<Long, Integer>();
    private final AtomicBoolean isClearInProgress = new AtomicBoolean(false);

    protected ConcurrentMap<Long, Integer> getInvalidationMap() {
        return this.invalidationMap;
    }

    public boolean isClearInProgress() {
        return this.isClearInProgress.get();
    }

    public void setClearInProgress(boolean clearInProgress) {
        this.isClearInProgress.set(clearInProgress);
    }

    protected long getInvalidationCount(long chainKey) {
        return this.getInvalidationMap().getOrDefault(chainKey, 0).intValue();
    }

    public void trackHashInvalidation(long chainKey) {
        this.getInvalidationMap().compute(chainKey, (key, count) -> {
            if (count == null) {
                return 1;
            }
            return count + 1;
        });
    }

    public void untrackHashInvalidation(long chainKey) {
        this.getInvalidationMap().computeIfPresent(chainKey, (key, count) -> {
            if (count == 1) {
                return null;
            }
            return count - 1;
        });
    }

    public Set<Long> getTrackedKeys() {
        return this.getInvalidationMap().keySet();
    }

    public void clear() {
        this.getInvalidationMap().clear();
    }
}

