/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.server;

import org.ehcache.clustered.common.internal.messages.EhcacheEntityMessage;
import org.ehcache.clustered.common.internal.messages.LifecycleMessage;
import org.ehcache.clustered.common.internal.messages.ServerStoreOpMessage;
import org.ehcache.clustered.common.internal.messages.StateRepositoryOpMessage;
import org.ehcache.clustered.server.internal.messages.EhcacheMessageTrackerCatchup;
import org.ehcache.clustered.server.internal.messages.EhcacheSyncMessage;
import org.ehcache.clustered.server.internal.messages.PassiveReplicationMessage;
import org.terracotta.entity.ExecutionStrategy;

public class EhcacheExecutionStrategy
implements ExecutionStrategy<EhcacheEntityMessage> {
    public ExecutionStrategy.Location getExecutionLocation(EhcacheEntityMessage message) {
        if (message instanceof ServerStoreOpMessage.ReplaceAtHeadMessage || message instanceof ServerStoreOpMessage.ClearMessage) {
            return ExecutionStrategy.Location.BOTH;
        }
        if (message instanceof ServerStoreOpMessage) {
            return ExecutionStrategy.Location.ACTIVE;
        }
        if (message instanceof LifecycleMessage.ValidateStoreManager) {
            return ExecutionStrategy.Location.ACTIVE;
        }
        if (message instanceof LifecycleMessage.ValidateServerStore) {
            return ExecutionStrategy.Location.ACTIVE;
        }
        if (message instanceof LifecycleMessage.PrepareForDestroy) {
            return ExecutionStrategy.Location.BOTH;
        }
        if (message instanceof StateRepositoryOpMessage.PutIfAbsentMessage) {
            return ExecutionStrategy.Location.BOTH;
        }
        if (message instanceof StateRepositoryOpMessage) {
            return ExecutionStrategy.Location.ACTIVE;
        }
        if (message instanceof PassiveReplicationMessage) {
            return ExecutionStrategy.Location.PASSIVE;
        }
        if (message instanceof EhcacheMessageTrackerCatchup) {
            return ExecutionStrategy.Location.PASSIVE;
        }
        if (message instanceof EhcacheSyncMessage) {
            throw new AssertionError((Object)"Unexpected use of ExecutionStrategy for sync messages");
        }
        throw new AssertionError((Object)("Unknown message type: " + message.getClass()));
    }
}

