/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.server.management;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.ehcache.clustered.common.PoolAllocation;
import org.ehcache.clustered.server.ServerSideServerStore;
import org.ehcache.clustered.server.management.ServerStoreBinding;
import org.terracotta.management.model.capabilities.descriptors.Descriptor;
import org.terracotta.management.model.capabilities.descriptors.Settings;
import org.terracotta.management.model.context.Context;
import org.terracotta.management.registry.Named;
import org.terracotta.management.registry.RequiredContext;
import org.terracotta.management.service.monitoring.registry.provider.AliasBinding;
import org.terracotta.management.service.monitoring.registry.provider.AliasBindingManagementProvider;
import org.terracotta.offheapstore.MapInternals;

@Named(value="ServerStoreSettings")
@RequiredContext(value={@Named(value="consumerId"), @Named(value="type"), @Named(value="alias")})
class ServerStoreSettingsManagementProvider
extends AliasBindingManagementProvider<ServerStoreBinding> {
    private final String clusterTierManagerIdentifier;
    private final String defaultServerResource;

    ServerStoreSettingsManagementProvider(String clusterTierManagerIdentifier, String defaultServerResource) {
        super(ServerStoreBinding.class);
        this.clusterTierManagerIdentifier = clusterTierManagerIdentifier;
        this.defaultServerResource = defaultServerResource;
    }

    public Collection<Descriptor> getDescriptors() {
        ArrayList<Descriptor> descriptors = new ArrayList<Descriptor>(super.getDescriptors());
        descriptors.add((Descriptor)new Settings().set("type", this.getCapabilityName()).set("clusterTierManager", this.clusterTierManagerIdentifier).set("time", (Number)System.currentTimeMillis()).set("defaultServerResource", this.defaultServerResource));
        return descriptors;
    }

    protected ExposedServerStoreBinding internalWrap(Context context, ServerStoreBinding managedObject) {
        if (this.defaultServerResource != null) {
            context = context.with("defaultServerResource", this.defaultServerResource);
        }
        return new ExposedServerStoreBinding(context, managedObject);
    }

    private static class ExposedServerStoreBinding
    extends AliasBindingManagementProvider.ExposedAliasBinding<ServerStoreBinding> {
        ExposedServerStoreBinding(Context context, ServerStoreBinding binding) {
            super(context.with("type", "ServerStore"), (AliasBinding)binding);
        }

        public Collection<? extends Descriptor> getDescriptors() {
            return Collections.singleton(this.getSettings());
        }

        Settings getSettings() {
            ServerSideServerStore value = ((ServerStoreBinding)this.getBinding()).getValue();
            PoolAllocation poolAllocation = value.getStoreConfiguration().getPoolAllocation();
            Settings settings = new Settings((Map)this.getContext()).set("resourcePoolType", poolAllocation.getClass().getSimpleName().toLowerCase());
            if (value instanceof MapInternals) {
                MapInternals internals = (MapInternals)value;
                settings.set("allocatedMemoryAtTime", (Number)internals.getAllocatedMemory()).set("tableCapacityAtTime", (Number)internals.getTableCapacity()).set("vitalMemoryAtTime", (Number)internals.getVitalMemory()).set("longSizeAtTime", (Number)internals.getSize()).set("dataAllocatedMemoryAtTime", (Number)internals.getDataAllocatedMemory()).set("dataOccupiedMemoryAtTime", (Number)internals.getDataOccupiedMemory()).set("dataSizeAtTime", (Number)internals.getDataSize()).set("dataVitalMemoryAtTime", (Number)internals.getDataVitalMemory());
            }
            if (poolAllocation instanceof PoolAllocation.DedicatedPoolAllocation) {
                String resourceName = ((PoolAllocation.DedicatedPoolAllocation)poolAllocation).getResourceName();
                settings.set("resourcePoolDedicatedResourceName", resourceName != null ? resourceName : settings.getString("defaultServerResource"));
                settings.set("resourcePoolDedicatedSize", (Number)((PoolAllocation.DedicatedPoolAllocation)poolAllocation).getSize());
            } else if (poolAllocation instanceof PoolAllocation.SharedPoolAllocation) {
                settings.set("resourcePoolSharedPoolName", ((PoolAllocation.SharedPoolAllocation)poolAllocation).getResourcePoolName());
            }
            return settings;
        }
    }
}

