/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.server;

import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.ehcache.clustered.common.ServerSideConfiguration;
import org.ehcache.clustered.common.internal.ClusterTierManagerConfiguration;
import org.ehcache.clustered.common.internal.exceptions.ClusterException;
import org.ehcache.clustered.common.internal.exceptions.InvalidOperationException;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityMessage;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityResponse;
import org.ehcache.clustered.common.internal.messages.EhcacheMessageType;
import org.ehcache.clustered.common.internal.messages.EhcacheOperationMessage;
import org.ehcache.clustered.common.internal.messages.LifecycleMessage;
import org.ehcache.clustered.server.ClusterTierManagerDump;
import org.ehcache.clustered.server.management.Management;
import org.ehcache.clustered.server.state.EhcacheStateService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.entity.ActiveInvokeContext;
import org.terracotta.entity.ActiveServerEntity;
import org.terracotta.entity.ClientDescriptor;
import org.terracotta.entity.ConfigurationException;
import org.terracotta.entity.PassiveSynchronizationChannel;
import org.terracotta.entity.StateDumpCollector;

public class ClusterTierManagerActiveEntity
implements ActiveServerEntity<EhcacheEntityMessage, EhcacheEntityResponse> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterTierManagerActiveEntity.class);
    private final EhcacheStateService ehcacheStateService;
    private final Management management;
    private final AtomicBoolean reconnectComplete = new AtomicBoolean(true);
    private final ServerSideConfiguration configuration;
    private final ClusterTierManagerConfiguration clusterTierManagerConfig;

    protected ClusterTierManagerActiveEntity() {
        this.ehcacheStateService = null;
        this.management = null;
        this.configuration = null;
        this.clusterTierManagerConfig = null;
    }

    public ClusterTierManagerActiveEntity(ClusterTierManagerConfiguration config, EhcacheStateService ehcacheStateService, Management management) throws ConfigurationException {
        this.clusterTierManagerConfig = config;
        if (config == null) {
            throw new ConfigurationException("ClusterTierManagerConfiguration cannot be null");
        }
        this.configuration = config.getConfiguration();
        this.ehcacheStateService = ehcacheStateService;
        if (ehcacheStateService == null) {
            throw new AssertionError((Object)"Server failed to retrieve EhcacheStateService.");
        }
        try {
            ehcacheStateService.configure();
            this.management = management;
        }
        catch (ConfigurationException e) {
            ehcacheStateService.destroy();
            throw e;
        }
    }

    public void addStateTo(StateDumpCollector dump) {
        ClusterTierManagerDump.dump(dump, this.clusterTierManagerConfig);
    }

    public void connected(ClientDescriptor clientDescriptor) {
        LOGGER.info("Connecting {}", (Object)clientDescriptor);
    }

    public void disconnected(ClientDescriptor clientDescriptor) {
        LOGGER.info("Disconnecting {}", (Object)clientDescriptor);
    }

    public EhcacheEntityResponse invokeActive(ActiveInvokeContext<EhcacheEntityResponse> invokeContext, EhcacheEntityMessage message) {
        try {
            EhcacheOperationMessage operationMessage;
            EhcacheMessageType messageType;
            if (message instanceof EhcacheOperationMessage && EhcacheMessageType.isLifecycleMessage((EhcacheMessageType)(messageType = (operationMessage = (EhcacheOperationMessage)message).getMessageType()))) {
                return this.invokeLifeCycleOperation(invokeContext.getClientDescriptor(), (LifecycleMessage)message);
            }
            throw new AssertionError((Object)("Unsupported message : " + message.getClass()));
        }
        catch (ClusterException e) {
            return EhcacheEntityResponse.failure((ClusterException)e);
        }
        catch (Exception e) {
            LOGGER.error("Unexpected exception raised during operation: " + message, (Throwable)e);
            return EhcacheEntityResponse.failure((ClusterException)new InvalidOperationException((Throwable)e));
        }
    }

    public ActiveServerEntity.ReconnectHandler startReconnect() {
        return (clientDescriptor, bytes) -> LOGGER.info("Client '{}' successfully reconnected to newly promoted ACTIVE after failover.", (Object)clientDescriptor);
    }

    public void synchronizeKeyToPassive(PassiveSynchronizationChannel<EhcacheEntityMessage> syncChannel, int concurrencyKey) {
    }

    public void createNew() {
        this.management.entityCreated();
        this.management.sharedPoolsConfigured();
    }

    public void loadExisting() {
        this.ehcacheStateService.loadExisting(this.configuration);
        LOGGER.debug("Preparing for handling Inflight Invalidations and independent Passive Evictions in loadExisting");
        this.reconnectComplete.set(false);
        this.management.entityPromotionCompleted();
        this.management.sharedPoolsConfigured();
    }

    private EhcacheEntityResponse invokeLifeCycleOperation(ClientDescriptor clientDescriptor, LifecycleMessage message) throws ClusterException {
        switch (message.getMessageType()) {
            case VALIDATE: {
                this.validate(clientDescriptor, (LifecycleMessage.ValidateStoreManager)message);
                break;
            }
            case PREPARE_FOR_DESTROY: {
                return this.prepareForDestroy();
            }
            default: {
                throw new AssertionError((Object)("Unsupported LifeCycle operation " + message));
            }
        }
        return EhcacheEntityResponse.success();
    }

    private EhcacheEntityResponse prepareForDestroy() {
        EhcacheEntityResponse.PrepareForDestroy response = EhcacheEntityResponse.prepareForDestroy((Set)this.ehcacheStateService.getStores());
        this.ehcacheStateService.prepareForDestroy();
        return response;
    }

    public void destroy() {
        this.ehcacheStateService.destroy();
        this.management.close();
    }

    private void validate(ClientDescriptor clientDescriptor, LifecycleMessage.ValidateStoreManager message) throws ClusterException {
        this.ehcacheStateService.validate(message.getConfiguration());
    }
}

