/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.server.store;

import org.ehcache.clustered.common.internal.messages.CommonConfigCodec;
import org.ehcache.clustered.common.internal.messages.ConfigCodec;
import org.ehcache.clustered.common.internal.messages.EhcacheCodec;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityMessage;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityResponse;
import org.ehcache.clustered.common.internal.messages.EntityConfigurationCodec;
import org.ehcache.clustered.common.internal.messages.LifeCycleMessageCodec;
import org.ehcache.clustered.common.internal.messages.ResponseCodec;
import org.ehcache.clustered.common.internal.messages.ServerStoreOpCodec;
import org.ehcache.clustered.common.internal.messages.StateRepositoryOpCodec;
import org.ehcache.clustered.common.internal.store.ClusterTierEntityConfiguration;
import org.ehcache.clustered.server.ConcurrencyStrategies;
import org.ehcache.clustered.server.EhcacheExecutionStrategy;
import org.ehcache.clustered.server.KeySegmentMapper;
import org.ehcache.clustered.server.internal.messages.EhcacheServerCodec;
import org.ehcache.clustered.server.internal.messages.EhcacheSyncMessageCodec;
import org.ehcache.clustered.server.internal.messages.PassiveReplicationMessageCodec;
import org.ehcache.clustered.server.store.ClusterTierActiveEntity;
import org.ehcache.clustered.server.store.ClusterTierPassiveEntity;
import org.terracotta.entity.CommonServerEntity;
import org.terracotta.entity.ConcurrencyStrategy;
import org.terracotta.entity.ConfigurationException;
import org.terracotta.entity.EntityServerService;
import org.terracotta.entity.ExecutionStrategy;
import org.terracotta.entity.MessageCodec;
import org.terracotta.entity.ServiceRegistry;
import org.terracotta.entity.SyncMessageCodec;

public class ClusterTierServerEntityService
implements EntityServerService<EhcacheEntityMessage, EhcacheEntityResponse> {
    private static final long ENTITY_VERSION = 10L;
    private static final int DEFAULT_CONCURRENCY = 16;
    private static final KeySegmentMapper DEFAULT_MAPPER = new KeySegmentMapper(16);
    private static final ConfigCodec CONFIG_CODEC = new CommonConfigCodec();
    private final EntityConfigurationCodec configCodec = new EntityConfigurationCodec(CONFIG_CODEC);

    public long getVersion() {
        return 10L;
    }

    public boolean handlesEntityType(String typeName) {
        return typeName.equals("org.ehcache.clustered.client.internal.store.ClusterTierClientEntity");
    }

    public ClusterTierActiveEntity createActiveEntity(ServiceRegistry registry, byte[] configuration) throws ConfigurationException {
        ClusterTierEntityConfiguration clusterTierEntityConfiguration = this.configCodec.decodeClusteredStoreConfiguration(configuration);
        return new ClusterTierActiveEntity(registry, clusterTierEntityConfiguration, DEFAULT_MAPPER);
    }

    public ClusterTierPassiveEntity createPassiveEntity(ServiceRegistry registry, byte[] configuration) throws ConfigurationException {
        ClusterTierEntityConfiguration clusterTierEntityConfiguration = this.configCodec.decodeClusteredStoreConfiguration(configuration);
        return new ClusterTierPassiveEntity(registry, clusterTierEntityConfiguration, DEFAULT_MAPPER);
    }

    public ConcurrencyStrategy<EhcacheEntityMessage> getConcurrencyStrategy(byte[] configuration) {
        return ConcurrencyStrategies.clusterTierConcurrency(DEFAULT_MAPPER);
    }

    public MessageCodec<EhcacheEntityMessage, EhcacheEntityResponse> getMessageCodec() {
        EhcacheCodec ehcacheCodec = new EhcacheCodec(new ServerStoreOpCodec(), new LifeCycleMessageCodec(CONFIG_CODEC), new StateRepositoryOpCodec(), new ResponseCodec());
        return new EhcacheServerCodec(ehcacheCodec, new PassiveReplicationMessageCodec());
    }

    public SyncMessageCodec<EhcacheEntityMessage> getSyncMessageCodec() {
        return new EhcacheSyncMessageCodec(new ResponseCodec());
    }

    public ExecutionStrategy<EhcacheEntityMessage> getExecutionStrategy(byte[] configuration) {
        return new EhcacheExecutionStrategy();
    }

    public <AP extends CommonServerEntity<EhcacheEntityMessage, EhcacheEntityResponse>> AP reconfigureEntity(ServiceRegistry registry, AP oldEntity, byte[] configuration) {
        throw new UnsupportedOperationException("Reconfigure not supported in Ehcache");
    }
}

