/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.server.internal.messages;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.ehcache.clustered.common.internal.messages.ConcurrentEntityMessage;
import org.ehcache.clustered.common.internal.messages.EhcacheMessageType;
import org.ehcache.clustered.common.internal.messages.EhcacheOperationMessage;
import org.ehcache.clustered.common.internal.store.Chain;
import org.ehcache.clustered.common.internal.util.ChainBuilder;

public abstract class PassiveReplicationMessage
extends EhcacheOperationMessage {

    public static class InvalidationCompleteMessage
    extends PassiveReplicationMessage
    implements ConcurrentEntityMessage {
        private final long key;

        public InvalidationCompleteMessage(long key) {
            this.key = key;
        }

        public long concurrencyKey() {
            return this.key;
        }

        public EhcacheMessageType getMessageType() {
            return EhcacheMessageType.INVALIDATION_COMPLETE;
        }

        public long getKey() {
            return this.key;
        }
    }

    public static class ClearInvalidationCompleteMessage
    extends PassiveReplicationMessage {
        public EhcacheMessageType getMessageType() {
            return EhcacheMessageType.CLEAR_INVALIDATION_COMPLETE;
        }
    }

    public static class ChainReplicationMessage
    extends PassiveReplicationMessage
    implements ConcurrentEntityMessage {
        private final long clientId;
        private final long key;
        private final Chain chain;
        private final long transactionId;
        private final long oldestTransactionId;

        public ChainReplicationMessage(long key, Chain chain, long transactionId, long oldestTransactionId, long clientId) {
            this.clientId = clientId;
            this.transactionId = transactionId;
            this.oldestTransactionId = oldestTransactionId;
            this.key = key;
            this.chain = chain;
        }

        private Chain dropLastElement(Chain chain) {
            if (chain.isEmpty()) {
                return chain;
            }
            List elements = StreamSupport.stream(chain.spliterator(), false).collect(Collectors.toList());
            elements.remove(elements.size() - 1);
            return ChainBuilder.chainFromList(elements);
        }

        public long getClientId() {
            return this.clientId;
        }

        public long getTransactionId() {
            return this.transactionId;
        }

        public long getKey() {
            return this.key;
        }

        public Chain getChain() {
            return this.chain;
        }

        public Chain getResult() {
            return this.dropLastElement(this.chain);
        }

        public long getOldestTransactionId() {
            return this.oldestTransactionId;
        }

        public EhcacheMessageType getMessageType() {
            return EhcacheMessageType.CHAIN_REPLICATION_OP;
        }

        public long concurrencyKey() {
            return this.key;
        }
    }
}

