/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.server.management;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.ehcache.clustered.server.management.PoolBinding;
import org.ehcache.clustered.server.state.EhcacheStateService;
import org.terracotta.management.model.context.Context;
import org.terracotta.management.model.stats.StatisticRegistry;
import org.terracotta.management.registry.ExposedObject;
import org.terracotta.management.registry.Named;
import org.terracotta.management.registry.RequiredContext;
import org.terracotta.management.registry.collect.StatisticProvider;
import org.terracotta.management.service.monitoring.registry.provider.AbstractExposedStatistics;
import org.terracotta.management.service.monitoring.registry.provider.AbstractStatisticsManagementProvider;
import org.terracotta.management.service.monitoring.registry.provider.AliasBinding;
import org.terracotta.statistics.registry.ValueStatisticDescriptor;

@Named(value="PoolStatistics")
@RequiredContext(value={@Named(value="consumerId"), @Named(value="type"), @Named(value="alias")})
@StatisticProvider
class PoolStatisticsManagementProvider
extends AbstractStatisticsManagementProvider<PoolBinding> {
    private final EhcacheStateService ehcacheStateService;

    PoolStatisticsManagementProvider(EhcacheStateService ehcacheStateService) {
        super(PoolBinding.class);
        this.ehcacheStateService = ehcacheStateService;
    }

    public Collection<ExposedObject<PoolBinding>> getExposedObjects() {
        return super.getExposedObjects().stream().filter(e -> e.getTarget() != PoolBinding.ALL_SHARED).collect(Collectors.toList());
    }

    protected StatisticRegistry getStatisticRegistry(PoolBinding managedObject) {
        if (managedObject == PoolBinding.ALL_SHARED) {
            return new StatisticRegistry(null, () -> this.getTimeSource().getTimestamp());
        }
        String poolName = managedObject.getAlias();
        PoolBinding.AllocationType allocationType = managedObject.getAllocationType();
        if (allocationType == PoolBinding.AllocationType.DEDICATED) {
            return new StatisticRegistry(this.ehcacheStateService.getDedicatedResourcePageSource(poolName), () -> this.getTimeSource().getTimestamp());
        }
        return new StatisticRegistry(this.ehcacheStateService.getSharedResourcePageSource(poolName), () -> this.getTimeSource().getTimestamp());
    }

    protected AbstractExposedStatistics<PoolBinding> internalWrap(Context context, PoolBinding managedObject, StatisticRegistry statisticRegistry) {
        return new PoolExposedStatistics(context, managedObject, statisticRegistry);
    }

    private static Set<String> tags(String ... tags) {
        return new HashSet<String>(Arrays.asList(tags));
    }

    private static class PoolExposedStatistics
    extends AbstractExposedStatistics<PoolBinding> {
        PoolExposedStatistics(Context context, PoolBinding binding, StatisticRegistry statisticRegistry) {
            super(context.with("type", "Pool"), (AliasBinding)binding, statisticRegistry);
            this.getStatisticRegistry().registerStatistic("AllocatedSize", ValueStatisticDescriptor.descriptor((String)"allocatedSize", (Set)PoolStatisticsManagementProvider.tags(new String[]{"tier", "Pool"})));
        }
    }
}

