/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.transactions.xa.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.ehcache.core.spi.store.Store;
import org.ehcache.core.spi.time.TimeSource;
import org.ehcache.spi.resilience.StoreAccessException;
import org.ehcache.transactions.xa.internal.SoftLock;
import org.ehcache.transactions.xa.internal.TransactionId;
import org.ehcache.transactions.xa.internal.XAValueHolder;
import org.ehcache.transactions.xa.internal.commands.Command;
import org.ehcache.transactions.xa.internal.commands.StoreEvictCommand;
import org.ehcache.transactions.xa.internal.commands.StorePutCommand;
import org.ehcache.transactions.xa.internal.commands.StoreRemoveCommand;
import org.ehcache.transactions.xa.internal.journal.Journal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XATransactionContext<K, V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(XATransactionContext.class);
    private final ConcurrentHashMap<K, Command<V>> commands = new ConcurrentHashMap();
    private final TransactionId transactionId;
    private final Store<K, SoftLock<V>> underlyingStore;
    private final Journal<K> journal;
    private final TimeSource timeSource;
    private final long timeoutTimestamp;

    XATransactionContext(TransactionId transactionId, Store<K, SoftLock<V>> underlyingStore, Journal<K> journal, TimeSource timeSource, long timeoutTimestamp) {
        this.transactionId = transactionId;
        this.underlyingStore = underlyingStore;
        this.journal = journal;
        this.timeSource = timeSource;
        this.timeoutTimestamp = timeoutTimestamp;
    }

    public boolean hasTimedOut() {
        return this.timeSource.getTimeMillis() >= this.timeoutTimestamp;
    }

    public TransactionId getTransactionId() {
        return this.transactionId;
    }

    public boolean addCommand(K key, Command<V> command) {
        if (this.commands.get(key) instanceof StoreEvictCommand) {
            return false;
        }
        this.commands.put(key, command);
        return true;
    }

    public void removeCommand(K key) {
        this.commands.remove(key);
    }

    public Map<K, XAValueHolder<V>> newValueHolders() {
        HashMap<K, XAValueHolder<V>> puts = new HashMap<K, XAValueHolder<V>>();
        for (Map.Entry<K, Command<V>> entry : this.commands.entrySet()) {
            Command<V> command = entry.getValue();
            if (!(command instanceof StorePutCommand)) continue;
            puts.put(entry.getKey(), entry.getValue().getNewValueHolder());
        }
        return puts;
    }

    public boolean touched(K key) {
        return this.commands.containsKey(key);
    }

    public boolean removed(K key) {
        return this.commands.get(key) instanceof StoreRemoveCommand;
    }

    public boolean updated(K key) {
        return this.commands.get(key) instanceof StorePutCommand;
    }

    public boolean evicted(K key) {
        return this.commands.get(key) instanceof StoreEvictCommand;
    }

    public V oldValueOf(K key) {
        Command<V> command = this.commands.get(key);
        return command != null ? (V)command.getOldValue() : null;
    }

    public XAValueHolder<V> newValueHolderOf(K key) {
        Command<V> command = this.commands.get(key);
        return command != null ? command.getNewValueHolder() : null;
    }

    public V newValueOf(K key) {
        Command<V> command = this.commands.get(key);
        XAValueHolder<V> valueHolder = command == null ? null : command.getNewValueHolder();
        return valueHolder == null ? null : (V)valueHolder.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int prepare() throws StoreAccessException, IllegalStateException, TransactionTimeoutException {
        try {
            if (this.hasTimedOut()) {
                throw new TransactionTimeoutException();
            }
            if (this.journal.isInDoubt(this.transactionId)) {
                throw new IllegalStateException("Cannot prepare transaction that is not in-flight : " + this.transactionId);
            }
            this.journal.saveInDoubt(this.transactionId, this.commands.keySet());
            for (Map.Entry<K, Command<V>> entry : this.commands.entrySet()) {
                if (entry.getValue() instanceof StoreEvictCommand) {
                    this.evictFromUnderlyingStore(entry.getKey());
                    continue;
                }
                V oldValue = entry.getValue().getOldValue();
                SoftLock<V> oldSoftLock = oldValue == null ? null : new SoftLock<V>(null, oldValue, null);
                SoftLock<V> newSoftLock = new SoftLock<V>(this.transactionId, oldValue, entry.getValue().getNewValueHolder());
                if (oldSoftLock != null) {
                    boolean replaced = this.replaceInUnderlyingStore(entry.getKey(), oldSoftLock, newSoftLock);
                    if (replaced) continue;
                    LOGGER.debug("prepare failed replace of softlock (concurrent modification?)");
                    this.evictFromUnderlyingStore(entry.getKey());
                    continue;
                }
                Store.ValueHolder<SoftLock<V>> existing = this.putIfAbsentInUnderlyingStore(entry, newSoftLock);
                if (existing == null) continue;
                LOGGER.debug("prepare failed putIfAbsent of softlock (concurrent modification?)");
                this.evictFromUnderlyingStore(entry.getKey());
            }
            if (this.commands.isEmpty()) {
                this.journal.saveRolledBack(this.transactionId, false);
            }
            int n = this.commands.size();
            return n;
        }
        finally {
            this.commands.clear();
        }
    }

    public void commit(boolean recovering) throws StoreAccessException, IllegalStateException, IllegalArgumentException {
        if (!this.journal.isInDoubt(this.transactionId)) {
            if (recovering) {
                throw new IllegalStateException("Cannot commit unknown transaction : " + this.transactionId);
            }
            throw new IllegalArgumentException("Cannot commit transaction that has not been prepared : " + this.transactionId);
        }
        Collection<K> keys = this.journal.getInDoubtKeys(this.transactionId);
        for (K key : keys) {
            SoftLock<V> definitiveSoftLock;
            SoftLock<V> preparedSoftLock = this.getFromUnderlyingStore(key);
            XAValueHolder<V> newValueHolder = preparedSoftLock == null ? null : preparedSoftLock.getNewValueHolder();
            SoftLock<V> softLock = definitiveSoftLock = newValueHolder == null ? null : new SoftLock<V>(null, newValueHolder.get(), null);
            if (preparedSoftLock != null) {
                if (preparedSoftLock.getTransactionId() != null && !preparedSoftLock.getTransactionId().equals(this.transactionId)) {
                    LOGGER.debug("commit skipping prepared softlock with non-matching TX ID (concurrent modification?)");
                    this.evictFromUnderlyingStore(key);
                    continue;
                }
                if (definitiveSoftLock != null) {
                    boolean replaced = this.replaceInUnderlyingStore(key, preparedSoftLock, definitiveSoftLock);
                    if (replaced) continue;
                    LOGGER.debug("commit failed replace of softlock (concurrent modification?)");
                    this.evictFromUnderlyingStore(key);
                    continue;
                }
                boolean removed = this.removeFromUnderlyingStore(key, preparedSoftLock);
                if (removed) continue;
                LOGGER.debug("commit failed remove of softlock (concurrent modification?)");
                this.evictFromUnderlyingStore(key);
                continue;
            }
            LOGGER.debug("commit skipping evicted prepared softlock");
        }
        this.journal.saveCommitted(this.transactionId, false);
    }

    public void commitInOnePhase() throws StoreAccessException, IllegalStateException, TransactionTimeoutException {
        if (this.journal.isInDoubt(this.transactionId)) {
            throw new IllegalStateException("Cannot commit-one-phase transaction that has been prepared : " + this.transactionId);
        }
        int prepared = this.prepare();
        if (prepared > 0) {
            this.commit(false);
        }
    }

    public void rollback(boolean recovering) throws StoreAccessException, IllegalStateException {
        boolean inDoubt = this.journal.isInDoubt(this.transactionId);
        if (inDoubt) {
            Collection<K> keys = this.journal.getInDoubtKeys(this.transactionId);
            for (K key : keys) {
                SoftLock<Object> definitiveSoftLock;
                SoftLock<V> preparedSoftLock = this.getFromUnderlyingStore(key);
                Object oldValue = preparedSoftLock == null ? null : (Object)preparedSoftLock.getOldValue();
                SoftLock<Object> softLock = definitiveSoftLock = oldValue == null ? null : new SoftLock<Object>(null, oldValue, (XAValueHolder<Object>)null);
                if (preparedSoftLock != null) {
                    if (preparedSoftLock.getTransactionId() != null && !preparedSoftLock.getTransactionId().equals(this.transactionId)) {
                        LOGGER.debug("rollback skipping prepared softlock with non-matching TX ID (concurrent modification?)");
                        this.evictFromUnderlyingStore(key);
                        continue;
                    }
                    if (definitiveSoftLock != null) {
                        boolean replaced = this.replaceInUnderlyingStore(key, preparedSoftLock, definitiveSoftLock);
                        if (replaced) continue;
                        LOGGER.debug("rollback failed replace of softlock (concurrent modification?)");
                        this.evictFromUnderlyingStore(key);
                        continue;
                    }
                    boolean removed = this.removeFromUnderlyingStore(key, preparedSoftLock);
                    if (removed) continue;
                    LOGGER.debug("rollback failed remove of softlock (concurrent modification?)");
                    this.evictFromUnderlyingStore(key);
                    continue;
                }
                LOGGER.debug("rollback skipping evicted prepared softlock");
            }
            this.journal.saveRolledBack(this.transactionId, false);
        } else {
            if (recovering) {
                throw new IllegalStateException("Cannot rollback unknown transaction : " + this.transactionId);
            }
            this.commands.clear();
        }
    }

    private boolean removeFromUnderlyingStore(K key, SoftLock<V> preparedSoftLock) throws StoreAccessException {
        return this.underlyingStore.remove(key, preparedSoftLock).equals((Object)Store.RemoveStatus.REMOVED);
    }

    private boolean replaceInUnderlyingStore(K key, SoftLock<V> preparedSoftLock, SoftLock<V> definitiveSoftLock) throws StoreAccessException {
        return this.underlyingStore.replace(key, preparedSoftLock, definitiveSoftLock).equals((Object)Store.ReplaceStatus.HIT);
    }

    private Store.ValueHolder<SoftLock<V>> putIfAbsentInUnderlyingStore(Map.Entry<K, Command<V>> entry, SoftLock<V> newSoftLock) throws StoreAccessException {
        return this.underlyingStore.putIfAbsent(entry.getKey(), newSoftLock, b -> {});
    }

    private SoftLock<V> getFromUnderlyingStore(K key) throws StoreAccessException {
        Store.ValueHolder softLockValueHolder = this.underlyingStore.get(key);
        return softLockValueHolder == null ? null : (SoftLock)softLockValueHolder.get();
    }

    private void evictFromUnderlyingStore(K key) throws StoreAccessException {
        this.underlyingStore.remove(key);
    }

    static class TransactionTimeoutException
    extends RuntimeException {
        private static final long serialVersionUID = -4629992436523905812L;

        TransactionTimeoutException() {
        }
    }
}

