/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.transactions.xa.internal.xml;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.ehcache.spi.service.ServiceConfiguration;
import org.ehcache.transactions.xa.configuration.XAStoreConfiguration;
import org.ehcache.transactions.xa.internal.XAStore;
import org.ehcache.transactions.xa.internal.xml.TxCacheManagerServiceConfigurationParser;
import org.ehcache.xml.BaseConfigParser;
import org.ehcache.xml.CacheServiceConfigurationParser;
import org.ehcache.xml.exceptions.XmlConfigurationException;
import org.osgi.service.component.annotations.Component;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Component
public class TxCacheServiceConfigurationParser
extends BaseConfigParser<XAStoreConfiguration>
implements CacheServiceConfigurationParser<XAStore.Provider> {
    private static final URI NAMESPACE = URI.create("http://www.ehcache.org/v3/tx");
    private static final URL XML_SCHEMA = TxCacheManagerServiceConfigurationParser.class.getResource("/ehcache-tx-ext.xsd");
    private static final String STORE_ELEMENT_NAME = "xa-store";
    private static final String UNIQUE_RESOURCE_NAME = "unique-XAResource-id";

    public Source getXmlSchema() throws IOException {
        return new StreamSource(XML_SCHEMA.openStream());
    }

    public URI getNamespace() {
        return NAMESPACE;
    }

    public ServiceConfiguration<XAStore.Provider, ?> parseServiceConfiguration(Element fragment, ClassLoader classLoader) {
        String localName = fragment.getLocalName();
        if (STORE_ELEMENT_NAME.equals(localName)) {
            String uniqueXAResourceId = fragment.getAttribute(UNIQUE_RESOURCE_NAME);
            return new XAStoreConfiguration(uniqueXAResourceId);
        }
        throw new XmlConfigurationException(String.format("XML configuration element <%s> in <%s> is not supported", fragment.getTagName(), fragment.getParentNode() == null ? "null" : fragment.getParentNode().getLocalName()));
    }

    public Class<XAStore.Provider> getServiceType() {
        return XAStore.Provider.class;
    }

    public Element unparseServiceConfiguration(ServiceConfiguration<XAStore.Provider, ?> serviceConfiguration) {
        return this.unparseConfig(serviceConfiguration);
    }

    protected Element createRootElement(Document doc, XAStoreConfiguration storeConfiguration) {
        Element rootElement = doc.createElementNS(NAMESPACE.toString(), "tx:xa-store");
        rootElement.setAttribute(UNIQUE_RESOURCE_NAME, storeConfiguration.getUniqueXAResourceId());
        return rootElement;
    }
}

