/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.transactions.xa.internal.xml;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.ehcache.core.internal.util.ClassLoading;
import org.ehcache.spi.service.ServiceCreationConfiguration;
import org.ehcache.transactions.xa.txmgr.provider.LookupTransactionManagerProviderConfiguration;
import org.ehcache.transactions.xa.txmgr.provider.TransactionManagerProvider;
import org.ehcache.xml.CacheManagerServiceConfigurationParser;
import org.ehcache.xml.exceptions.XmlConfigurationException;
import org.w3c.dom.Element;

public class TxCacheManagerServiceConfigurationParser
implements CacheManagerServiceConfigurationParser<TransactionManagerProvider> {
    private static final URI NAMESPACE = URI.create("http://www.ehcache.org/v3/tx");
    private static final URL XML_SCHEMA = TxCacheManagerServiceConfigurationParser.class.getResource("/ehcache-tx-ext.xsd");

    public Source getXmlSchema() throws IOException {
        return new StreamSource(XML_SCHEMA.openStream());
    }

    public URI getNamespace() {
        return NAMESPACE;
    }

    public ServiceCreationConfiguration<TransactionManagerProvider> parseServiceCreationConfiguration(Element fragment) {
        String localName = fragment.getLocalName();
        if ("jta-tm".equals(localName)) {
            String transactionManagerProviderConfigurationClassName = fragment.getAttribute("transaction-manager-lookup-class");
            try {
                Class<?> aClass;
                ClassLoader defaultClassLoader = ClassLoading.getDefaultClassLoader();
                Class<?> clazz = aClass = Class.forName(transactionManagerProviderConfigurationClassName, true, defaultClassLoader);
                return new LookupTransactionManagerProviderConfiguration(clazz);
            }
            catch (Exception e) {
                throw new XmlConfigurationException("Error configuring XA transaction manager", (Throwable)e);
            }
        }
        throw new XmlConfigurationException(String.format("XML configuration element <%s> in <%s> is not supported", fragment.getTagName(), fragment.getParentNode() == null ? "null" : fragment.getParentNode().getLocalName()));
    }

    public Class<TransactionManagerProvider> getServiceType() {
        return null;
    }

    public Element unparseServiceCreationConfiguration(ServiceCreationConfiguration<TransactionManagerProvider> serviceCreationConfiguration) {
        throw new UnsupportedOperationException("Not yet implemented");
    }
}

