/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.transactions.xa.internal.xml;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.ehcache.spi.service.ServiceConfiguration;
import org.ehcache.transactions.xa.configuration.XAStoreConfiguration;
import org.ehcache.transactions.xa.internal.XAStore;
import org.ehcache.transactions.xa.internal.xml.TxCacheManagerServiceConfigurationParser;
import org.ehcache.xml.CacheServiceConfigurationParser;
import org.ehcache.xml.exceptions.XmlConfigurationException;
import org.w3c.dom.Element;

public class TxCacheServiceConfigurationParser
implements CacheServiceConfigurationParser<XAStore.Provider> {
    private static final URI NAMESPACE = URI.create("http://www.ehcache.org/v3/tx");
    private static final URL XML_SCHEMA = TxCacheManagerServiceConfigurationParser.class.getResource("/ehcache-tx-ext.xsd");

    public Source getXmlSchema() throws IOException {
        return new StreamSource(XML_SCHEMA.openStream());
    }

    public URI getNamespace() {
        return NAMESPACE;
    }

    public ServiceConfiguration<XAStore.Provider> parseServiceConfiguration(Element fragment) {
        String localName = fragment.getLocalName();
        if ("xa-store".equals(localName)) {
            String uniqueXAResourceId = fragment.getAttribute("unique-XAResource-id");
            return new XAStoreConfiguration(uniqueXAResourceId);
        }
        throw new XmlConfigurationException(String.format("XML configuration element <%s> in <%s> is not supported", fragment.getTagName(), fragment.getParentNode() == null ? "null" : fragment.getParentNode().getLocalName()));
    }

    public Class<XAStore.Provider> getServiceType() {
        return null;
    }

    public Element unparseServiceConfiguration(ServiceConfiguration<XAStore.Provider> serviceConfiguration) {
        throw new UnsupportedOperationException("Not yet implemented");
    }
}

