/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.transactions.xa.internal.journal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.ehcache.impl.internal.concurrent.ConcurrentHashMap;
import org.ehcache.transactions.xa.internal.TransactionId;
import org.ehcache.transactions.xa.internal.journal.Journal;

public class TransientJournal<K>
implements Journal<K> {
    protected final ConcurrentHashMap<TransactionId, Entry<K>> states = new ConcurrentHashMap();

    @Override
    public void saveCommitted(TransactionId transactionId, boolean heuristicDecision) {
        this.save(transactionId, XAState.COMMITTED, heuristicDecision, Collections.emptySet());
    }

    @Override
    public void saveRolledBack(TransactionId transactionId, boolean heuristicDecision) {
        this.save(transactionId, XAState.ROLLED_BACK, heuristicDecision, Collections.emptySet());
    }

    @Override
    public void saveInDoubt(TransactionId transactionId, Collection<K> inDoubtKeys) {
        this.save(transactionId, XAState.IN_DOUBT, false, inDoubtKeys);
    }

    private void save(TransactionId transactionId, XAState xaState, boolean heuristicDecision, Collection<K> inDoubtKeys) {
        if (!heuristicDecision) {
            if (xaState == XAState.IN_DOUBT) {
                Entry existing = (Entry)this.states.putIfAbsent((Object)transactionId, new Entry<K>(xaState, false, inDoubtKeys));
                if (existing != null) {
                    throw new IllegalStateException("A transaction cannot go back to in-doubt state");
                }
            } else {
                Entry entry = (Entry)this.states.get((Object)transactionId);
                if (entry != null && entry.heuristic) {
                    throw new IllegalStateException("A heuristically terminated transaction cannot be normally terminated, it must be forgotten");
                }
                this.states.remove((Object)transactionId);
            }
        } else {
            if (xaState == XAState.IN_DOUBT) {
                throw new IllegalStateException("A transaction cannot enter in-doubt state heuristically");
            }
            Entry replaced = (Entry)this.states.replace((Object)transactionId, new Entry(xaState, true, Collections.emptySet()));
            if (replaced == null) {
                throw new IllegalStateException("Only in-doubt transactions can be heuristically terminated");
            }
        }
    }

    @Override
    public boolean isInDoubt(TransactionId transactionId) {
        Entry entry = (Entry)this.states.get((Object)transactionId);
        return entry != null && entry.state == XAState.IN_DOUBT;
    }

    @Override
    public Collection<K> getInDoubtKeys(TransactionId transactionId) {
        Entry entry = (Entry)this.states.get((Object)transactionId);
        if (entry == null || entry.heuristic) {
            return null;
        }
        return new ArrayList(entry.keys);
    }

    @Override
    public Map<TransactionId, Collection<K>> recover() {
        HashMap result = new HashMap();
        for (Map.Entry entry : this.states.entrySet()) {
            if (((Entry)entry.getValue()).heuristic) continue;
            result.put((TransactionId)entry.getKey(), new ArrayList(((Entry)entry.getValue()).keys));
        }
        return result;
    }

    @Override
    public boolean isHeuristicallyTerminated(TransactionId transactionId) {
        Entry entry = (Entry)this.states.get((Object)transactionId);
        return entry != null && entry.heuristic;
    }

    @Override
    public void forget(TransactionId transactionId) {
        Entry entry = (Entry)this.states.get((Object)transactionId);
        if (entry != null) {
            if (!entry.heuristic) {
                throw new IllegalStateException("Cannot forget non-heuristically terminated transaction");
            }
        } else {
            throw new IllegalStateException("Cannot forget unknown transaction");
        }
        this.states.remove((Object)transactionId);
    }

    @Override
    public Map<TransactionId, Boolean> heuristicDecisions() {
        HashMap<TransactionId, Boolean> result = new HashMap<TransactionId, Boolean>();
        for (Map.Entry entry : this.states.entrySet()) {
            if (!((Entry)entry.getValue()).heuristic) continue;
            result.put((TransactionId)entry.getKey(), ((Entry)entry.getValue()).state == XAState.COMMITTED);
        }
        return result;
    }

    @Override
    public void open() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }

    protected static class Entry<K> {
        final XAState state;
        final boolean heuristic;
        final Collection<K> keys;

        public Entry(XAState state, boolean heuristic, Collection<K> keys) {
            this.state = state;
            this.heuristic = heuristic;
            this.keys = new ArrayList<K>(keys);
        }
    }

    static enum XAState {
        IN_DOUBT,
        COMMITTED,
        ROLLED_BACK;

    }
}

