/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.transactions.xa.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.ehcache.core.util.ByteBufferInputStream;
import org.ehcache.spi.serialization.Serializer;
import org.ehcache.spi.serialization.SerializerException;
import org.ehcache.transactions.xa.internal.SoftLock;
import org.ehcache.transactions.xa.internal.TypeUtil;

class SoftLockSerializer<T>
implements Serializer<SoftLock<T>> {
    private final ClassLoader classLoader;

    SoftLockSerializer(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ByteBuffer serialize(SoftLock<T> object) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oout = new ObjectOutputStream(bout);
            oout.writeObject(object);
        }
        catch (IOException e) {
            throw new SerializerException((Throwable)e);
        }
        finally {
            try {
                bout.close();
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        }
        return ByteBuffer.wrap(bout.toByteArray());
    }

    public SoftLock<T> read(ByteBuffer entry) throws SerializerException, ClassNotFoundException {
        ByteBufferInputStream bin = new ByteBufferInputStream(entry);
        try {
            SoftLock softLock;
            OIS ois = new OIS((InputStream)bin, this.classLoader);
            try {
                softLock = (SoftLock)TypeUtil.uncheckedCast(ois.readObject());
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ois.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new SerializerException((Throwable)e);
                }
            }
            ois.close();
            return softLock;
        }
        finally {
            try {
                bin.close();
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    public boolean equals(SoftLock<T> object, ByteBuffer binary) throws SerializerException, ClassNotFoundException {
        return object.equals(this.read(binary));
    }

    private static class OIS
    extends ObjectInputStream {
        private final ClassLoader classLoader;
        private static final Map<String, Class<?>> primitiveClasses = new HashMap();

        public OIS(InputStream in, ClassLoader classLoader) throws IOException {
            super(in);
            this.classLoader = classLoader;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws ClassNotFoundException {
            try {
                return Class.forName(desc.getName(), false, this.classLoader);
            }
            catch (ClassNotFoundException cnfe) {
                Class<?> primitive = primitiveClasses.get(desc.getName());
                if (primitive != null) {
                    return primitive;
                }
                throw cnfe;
            }
        }

        @Override
        protected Class<?> resolveProxyClass(String[] interfaces) throws ClassNotFoundException {
            Class[] interfaceClasses = new Class[interfaces.length];
            for (int i = 0; i < interfaces.length; ++i) {
                interfaceClasses[i] = Class.forName(interfaces[i], false, this.classLoader);
            }
            return Proxy.getProxyClass(this.classLoader, interfaceClasses);
        }

        static {
            primitiveClasses.put("boolean", Boolean.TYPE);
            primitiveClasses.put("byte", Byte.TYPE);
            primitiveClasses.put("char", Character.TYPE);
            primitiveClasses.put("double", Double.TYPE);
            primitiveClasses.put("float", Float.TYPE);
            primitiveClasses.put("int", Integer.TYPE);
            primitiveClasses.put("long", Long.TYPE);
            primitiveClasses.put("short", Short.TYPE);
            primitiveClasses.put("void", Void.TYPE);
        }
    }
}

