/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.tcm;

import com.tc.async.api.Sink;
import com.tc.net.protocol.tcm.TCMessage;
import com.tc.net.protocol.tcm.TCMessageSink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCMessageHydrateSink<T>
implements TCMessageSink {
    private final Sink<T> destSink;
    private static final Logger LOGGER = LoggerFactory.getLogger(TCMessageHydrateSink.class);

    public TCMessageHydrateSink(Sink<T> destSink) {
        this.destSink = destSink;
    }

    @Override
    public void putMessage(TCMessage message) {
        try {
            message.hydrate();
            this.destSink.addToSink(message);
        }
        catch (Throwable t) {
            try {
                LOGGER.error("Error hydrating message of type " + (Object)((Object)message.getMessageType()), t);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            message.getChannel().close();
            return;
        }
    }
}

