/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.connection.entity;

import com.tc.object.ClientEntityManager;
import com.tc.object.ClientInstanceID;
import com.tc.object.EntityID;
import com.tc.util.Assert;
import com.tc.util.Throwables;
import com.tc.util.Util;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.connection.entity.Entity;
import org.terracotta.connection.entity.EntityRef;
import org.terracotta.entity.EndpointConnector;
import org.terracotta.entity.EntityClientEndpoint;
import org.terracotta.entity.EntityClientService;
import org.terracotta.entity.EntityMessage;
import org.terracotta.entity.EntityResponse;
import org.terracotta.exception.ConnectionClosedException;
import org.terracotta.exception.EntityAlreadyExistsException;
import org.terracotta.exception.EntityConfigurationException;
import org.terracotta.exception.EntityException;
import org.terracotta.exception.EntityNotFoundException;
import org.terracotta.exception.EntityNotProvidedException;
import org.terracotta.exception.EntityVersionMismatchException;
import org.terracotta.exception.PermanentEntityException;

public class TerracottaEntityRef<T extends Entity, C, U>
implements EntityRef<T, C, U> {
    private static final Logger logger = LoggerFactory.getLogger(TerracottaEntityRef.class);
    private final Supplier<ClientEntityManager> entityManager;
    private final EndpointConnector endpointConnector;
    private final Class<T> type;
    private final long version;
    private final String name;
    private final EntityClientService<T, C, ? extends EntityMessage, ? extends EntityResponse, U> entityClientService;
    private final AtomicLong nextClientInstanceID;

    public TerracottaEntityRef(Supplier<ClientEntityManager> entityManager, EndpointConnector endpointConnector, Class<T> type, long version, String name, EntityClientService<T, C, ? extends EntityMessage, ? extends EntityResponse, U> entityClientService, AtomicLong clientIds) {
        this.entityManager = entityManager;
        this.endpointConnector = endpointConnector;
        this.type = type;
        this.version = version;
        this.name = name;
        this.entityClientService = entityClientService;
        this.nextClientInstanceID = clientIds;
    }

    @Override
    public boolean isValid() {
        return this.entityManager.get().isValid();
    }

    @Override
    public synchronized T fetchEntity(U userData) throws EntityNotFoundException, EntityVersionMismatchException {
        EntityClientEndpoint endpoint = null;
        try {
            ClientInstanceID clientInstanceID = new ClientInstanceID(this.nextClientInstanceID.getAndIncrement());
            endpoint = this.entityManager.get().fetchEntity(this.getEntityID(), this.version, clientInstanceID, this.entityClientService.getMessageCodec(), null);
        }
        catch (EntityException e) {
            if (e instanceof EntityNotFoundException) {
                throw (EntityNotFoundException)e;
            }
            if (e instanceof EntityVersionMismatchException) {
                throw (EntityVersionMismatchException)e;
            }
            throw Assert.failure("Unsupported exception type returned to fetch", e);
        }
        catch (ConnectionClosedException closed) {
            throw closed;
        }
        catch (Throwable t) {
            Util.printLogAndRethrowError(t, logger);
        }
        if (endpoint == null) {
            Assert.assertNotNull(endpoint);
        }
        return this.endpointConnector.connect(endpoint, this.entityClientService, userData);
    }

    @Override
    public String getName() {
        return this.name;
    }

    private EntityID getEntityID() {
        return new EntityID(this.type.getName(), this.name);
    }

    @Override
    public void create(C configuration) throws EntityNotProvidedException, EntityAlreadyExistsException, EntityVersionMismatchException, EntityConfigurationException {
        EntityID entityID = this.getEntityID();
        try {
            this.entityManager.get().createEntity(entityID, this.version, this.entityClientService.serializeConfiguration(configuration));
        }
        catch (EntityException e) {
            if (e instanceof EntityNotProvidedException) {
                throw (EntityNotProvidedException)e;
            }
            if (e instanceof EntityAlreadyExistsException) {
                throw (EntityAlreadyExistsException)e;
            }
            if (e instanceof EntityVersionMismatchException) {
                throw (EntityVersionMismatchException)e;
            }
            if (e instanceof EntityConfigurationException) {
                throw (EntityConfigurationException)e;
            }
            throw Assert.failure("Unsupported exception type returned to create", e);
        }
    }

    @Override
    public C reconfigure(C configuration) throws EntityNotProvidedException, EntityNotFoundException, EntityConfigurationException {
        EntityID entityID = this.getEntityID();
        try {
            return this.entityClientService.deserializeConfiguration(this.entityManager.get().reconfigureEntity(entityID, this.version, this.entityClientService.serializeConfiguration(configuration)));
        }
        catch (EntityException e) {
            if (e instanceof EntityNotFoundException) {
                throw (EntityNotFoundException)e;
            }
            if (e instanceof EntityNotProvidedException) {
                throw (EntityNotProvidedException)e;
            }
            if (e instanceof EntityConfigurationException) {
                throw (EntityConfigurationException)e;
            }
            throw Assert.failure("Unsupported exception type returned to reconfigure", e);
        }
    }

    @Override
    public boolean destroy() throws EntityNotProvidedException, EntityNotFoundException, PermanentEntityException {
        EntityID entityID = this.getEntityID();
        try {
            return this.entityManager.get().destroyEntity(entityID, this.version);
        }
        catch (EntityException e) {
            if (e instanceof EntityNotProvidedException) {
                throw (EntityNotProvidedException)e;
            }
            if (e instanceof EntityNotFoundException) {
                throw (EntityNotFoundException)e;
            }
            throw Throwables.propagate(e);
        }
    }
}

