/*
 * Decompiled with CFR 0.152.
 */
package com.tc.util.version;

import com.tc.util.version.Version;

public class VersionCompatibility {
    private static final Version MINIMUM_COMPATIBLE_PERSISTENCE = new Version("4.1.2");

    public boolean isCompatibleClientServer(Version clientVersion, Version serverVersion) {
        return VersionCompatibility.isCompatible(clientVersion, serverVersion);
    }

    public boolean isCompatibleServerServer(Version v1, Version v2) {
        return VersionCompatibility.isCompatible(v1, v2);
    }

    public boolean isCompatibleServerPersistence(Version persisted, Version current) {
        if (persisted.compareTo(this.getMinimumCompatiblePersistence()) < 0) {
            return false;
        }
        if (persisted.major() == current.major() && persisted.minor() == current.minor()) {
            return true;
        }
        return current.compareTo(persisted) >= 0;
    }

    private static boolean isCompatible(Version v1, Version v2) {
        if (v1 == null || v2 == null) {
            throw new NullPointerException();
        }
        return v1.major() == v2.major() && v1.minor() == v2.minor();
    }

    public static boolean isNewer(Version v1, Version v2, int depth) {
        if (v1 == null || v2 == null) {
            throw new NullPointerException();
        }
        return v1.isNewer(v2, depth);
    }

    public Version getMinimumCompatiblePersistence() {
        return MINIMUM_COMPATIBLE_PERSISTENCE;
    }
}

