/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.tcm;

import com.tc.bytes.TCByteBuffer;
import com.tc.io.TCByteBufferOutput;
import com.tc.io.TCByteBufferOutputStream;
import com.tc.net.ClientID;
import com.tc.net.CommStackMismatchException;
import com.tc.net.MaxConnectionsExceededException;
import com.tc.net.NodeID;
import com.tc.net.ServerID;
import com.tc.net.core.ProductID;
import com.tc.net.protocol.NetworkLayer;
import com.tc.net.protocol.NetworkStackID;
import com.tc.net.protocol.TCNetworkMessage;
import com.tc.net.protocol.tcm.ChannelEventListener;
import com.tc.net.protocol.tcm.ChannelID;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.net.protocol.tcm.MessageChannelInternal;
import com.tc.net.protocol.tcm.MessageMonitor;
import com.tc.net.protocol.tcm.NullMessageMonitor;
import com.tc.net.protocol.tcm.TCMessage;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.net.protocol.transport.ConnectionID;
import com.tc.net.protocol.transport.MessageTransport;
import com.tc.util.TCTimeoutException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class MockMessageChannel
implements MessageChannelInternal {
    private final ChannelID channelId;
    private NetworkLayer sendLayer;
    BlockingQueue<Object> closedCalls = new LinkedBlockingQueue<Object>();
    private long lastClosedCallTimestamp;
    private final Map<TCMessageType, Class<? extends TCMessage>> knownMessageTypes;
    private int numSends;
    private TCNetworkMessage lastSentMessage;
    private NodeID source = ClientID.NULL_ID;
    private final NodeID destination = ServerID.NULL_ID;

    public MockMessageChannel(ChannelID channelId) {
        this.channelId = channelId;
        this.knownMessageTypes = new HashMap<TCMessageType, Class<? extends TCMessage>>();
        this.reset();
        this.source = new ClientID(channelId.toLong());
    }

    @Override
    public void reset() {
        this.numSends = 0;
        this.lastSentMessage = null;
    }

    public TCNetworkMessage getLastSentMessage() {
        return this.lastSentMessage;
    }

    public int getNumSends() {
        return this.numSends;
    }

    @Override
    public void addListener(ChannelEventListener listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isConnected() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isOpen() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isClosed() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        this.lastClosedCallTimestamp = System.currentTimeMillis();
        try {
            this.closedCalls.put(new Object());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public ChannelID getChannelID() {
        return this.channelId;
    }

    @Override
    public void setSendLayer(NetworkLayer layer) {
        this.sendLayer = layer;
    }

    @Override
    public void setReceiveLayer(NetworkLayer layer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void send(TCNetworkMessage message) {
        ++this.numSends;
        this.lastSentMessage = message;
    }

    @Override
    public void receive(TCByteBuffer[] msgData) {
        throw new UnsupportedOperationException();
    }

    @Override
    public NetworkStackID open(InetSocketAddress serverAddress) throws MaxConnectionsExceededException, TCTimeoutException, UnknownHostException, IOException, CommStackMismatchException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NetworkStackID open(Iterable<InetSocketAddress> serverAddresses) throws MaxConnectionsExceededException, TCTimeoutException, UnknownHostException, IOException, CommStackMismatchException {
        throw new UnsupportedOperationException();
    }

    @Override
    public TCMessage createMessage(TCMessageType type) {
        Class<? extends TCMessage> theClass = this.knownMessageTypes.get((Object)type);
        if (theClass == null) {
            throw new UnsupportedOperationException();
        }
        try {
            Constructor<? extends TCMessage> constructor = theClass.getConstructor(MessageMonitor.class, TCByteBufferOutput.class, MessageChannel.class, TCMessageType.class);
            return constructor.newInstance(new Object[]{new NullMessageMonitor(), new TCByteBufferOutputStream(4, 4096, false), this, type});
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("Failed", e);
        }
    }

    @Override
    public void notifyTransportConnected(MessageTransport transport) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void notifyTransportDisconnected(MessageTransport transport, boolean forcedDisconnect) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void notifyTransportConnectAttempt(MessageTransport transport) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void notifyTransportClosed(MessageTransport transport) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void notifyTransportReconnectionRejected(MessageTransport transport) {
        throw new UnsupportedOperationException();
    }

    public long getLastClosedCallTimestamp() {
        return this.lastClosedCallTimestamp;
    }

    public NetworkLayer getSendLayer() {
        return this.sendLayer;
    }

    @Override
    public Object getAttachment(String key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addAttachment(String key, Object value, boolean replace) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object removeAttachment(String key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        throw new UnsupportedOperationException();
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        throw new UnsupportedOperationException();
    }

    @Override
    public short getStackLayerFlag() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getStackLayerName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public NetworkLayer getReceiveLayer() {
        throw new UnsupportedOperationException();
    }

    @Override
    public NodeID getLocalNodeID() {
        return this.source;
    }

    @Override
    public void setLocalNodeID(NodeID source) {
        this.source = source;
    }

    @Override
    public NodeID getRemoteNodeID() {
        return this.destination;
    }

    @Override
    public ProductID getProductID() {
        return null;
    }

    @Override
    public ConnectionID getConnectionID() {
        return null;
    }
}

