/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.tcm;

import com.tc.net.ClientID;
import com.tc.net.CommStackMismatchException;
import com.tc.net.MaxConnectionsExceededException;
import com.tc.net.NodeID;
import com.tc.net.ServerID;
import com.tc.net.core.ProductID;
import com.tc.net.protocol.NetworkStackID;
import com.tc.net.protocol.TCNetworkMessage;
import com.tc.net.protocol.tcm.AbstractMessageChannel;
import com.tc.net.protocol.tcm.ChannelID;
import com.tc.net.protocol.tcm.ClientMessageChannel;
import com.tc.net.protocol.tcm.TCMessageFactory;
import com.tc.net.protocol.tcm.TCMessageRouter;
import com.tc.net.protocol.transport.ClientConnectionErrorListener;
import com.tc.net.protocol.transport.ConnectionID;
import com.tc.net.protocol.transport.JvmIDUtil;
import com.tc.net.protocol.transport.MessageTransport;
import com.tc.net.protocol.transport.MessageTransportInitiator;
import com.tc.object.session.SessionID;
import com.tc.object.session.SessionProvider;
import com.tc.util.TCTimeoutException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientMessageChannelImpl
extends AbstractMessageChannel
implements ClientMessageChannel {
    private static final Logger logger = LoggerFactory.getLogger(ClientMessageChannel.class);
    private int connectAttemptCount;
    private int connectCount;
    private volatile ChannelID channelID = ChannelID.NULL_ID;
    private final ProductID productID;
    private final SessionProvider sessionProvider;
    private MessageTransportInitiator initiator;
    private volatile SessionID channelSessionID = SessionID.NULL_ID;
    private final List<ClientConnectionErrorListener> errorListeners = new CopyOnWriteArrayList<ClientConnectionErrorListener>();

    protected ClientMessageChannelImpl(TCMessageFactory msgFactory, TCMessageRouter router, SessionProvider sessionProvider, ProductID productId) {
        super(router, logger, msgFactory);
        this.productID = productId;
        this.sessionProvider = sessionProvider;
        this.sessionProvider.initProvider();
    }

    @Override
    public void setMessageTransportInitiator(MessageTransportInitiator initiator) {
        this.initiator = initiator;
    }

    @Override
    public void reset() {
        AbstractMessageChannel.ChannelStatus status = this.getStatus();
        status.reset();
        this.sendLayer.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetworkStackID open(Iterable<InetSocketAddress> serverAddresses) throws TCTimeoutException, UnknownHostException, IOException, MaxConnectionsExceededException, CommStackMismatchException {
        AbstractMessageChannel.ChannelStatus status;
        AbstractMessageChannel.ChannelStatus channelStatus = status = this.getStatus();
        synchronized (channelStatus) {
            if (this.isOpen()) {
                throw new IllegalStateException("Channel already open");
            }
            ConnectionID cid = new ConnectionID(JvmIDUtil.getJvmID(), ((ClientID)this.getLocalNodeID()).toLong(), this.productID);
            NetworkStackID id = this.initiator.openMessageTransport(serverAddresses, cid);
            this.channelSessionID = this.sessionProvider.getSessionID();
            if (this.isClosed()) {
                throw new IOException("connection closed");
            }
            this.channelOpened();
            return id;
        }
    }

    @Override
    public NodeID getRemoteNodeID() {
        return ServerID.NULL_ID;
    }

    @Override
    public ProductID getProductID() {
        return this.getProductID(this.productID);
    }

    @Override
    public ChannelID getChannelID() {
        return this.channelID;
    }

    @Override
    public int getConnectCount() {
        return this.connectCount;
    }

    @Override
    public int getConnectAttemptCount() {
        return this.connectAttemptCount;
    }

    @Override
    public void send(TCNetworkMessage message) throws IOException {
        super.send(message);
    }

    @Override
    public void notifyTransportConnected(MessageTransport transport) {
        if (!transport.getConnectionID().isNull()) {
            long channelIdLong = transport.getConnectionID().getChannelID();
            this.channelID = new ChannelID(channelIdLong);
            this.setLocalNodeID(new ClientID(channelIdLong));
            ++this.connectCount;
        }
        super.notifyTransportConnected(transport);
    }

    @Override
    public void notifyTransportDisconnected(MessageTransport transport, boolean forcedDisconnect) {
        this.channelSessionID = this.sessionProvider.nextSessionID();
        logger.debug("ClientMessageChannel moves to " + this.channelSessionID + " for remote node " + this.getRemoteNodeID());
        super.notifyTransportDisconnected(transport, forcedDisconnect);
    }

    @Override
    public void notifyTransportConnectAttempt(MessageTransport transport) {
        super.notifyTransportConnectAttempt(transport);
        ++this.connectAttemptCount;
    }

    @Override
    public void notifyTransportClosed(MessageTransport transport) {
        super.notifyTransportClosed(transport);
    }

    @Override
    public ClientID getClientID() {
        return (ClientID)this.getLocalNodeID();
    }

    @Override
    public void addClientConnectionErrorListener(ClientConnectionErrorListener errorListener) {
        this.errorListeners.add(errorListener);
    }

    @Override
    public void removeClientConnectionErrorListener(ClientConnectionErrorListener errorListener) {
        this.errorListeners.remove(errorListener);
    }

    @Override
    public void onError(InetSocketAddress serverAddress, Exception e) {
        this.errorListeners.forEach(l -> l.onError(serverAddress, e));
    }
}

