/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.common.internal.store.operations;

import java.nio.ByteBuffer;
import org.ehcache.clustered.common.internal.store.operations.codecs.CodecException;
import org.ehcache.spi.serialization.Serializer;

class LazyValueHolder<V> {
    private V value;
    private ByteBuffer encodedValue;
    private final Serializer<V> valueSerializer;

    LazyValueHolder(V value) {
        if (value == null) {
            throw new NullPointerException("Value can not be null");
        }
        this.value = value;
        this.encodedValue = null;
        this.valueSerializer = null;
    }

    LazyValueHolder(ByteBuffer encodedValue, Serializer<V> valueSerializer) {
        this.encodedValue = encodedValue;
        this.valueSerializer = valueSerializer;
        this.value = null;
    }

    public V getValue() {
        if (this.value == null) {
            try {
                this.value = this.valueSerializer.read(this.encodedValue);
            }
            catch (ClassNotFoundException e) {
                throw new CodecException(e);
            }
        }
        return this.value;
    }

    public ByteBuffer encode(Serializer<V> valueSerializer) {
        if (this.encodedValue == null) {
            this.encodedValue = valueSerializer.serialize(this.value);
        }
        return this.encodedValue.duplicate();
    }
}

