/*
 * Decompiled with CFR 0.152.
 */
package com.tc.util;

import com.tc.productinfo.BuildInfo;
import com.tc.productinfo.Description;
import com.tc.productinfo.ExtensionInfo;
import com.tc.productinfo.PatchInfo;
import com.tc.util.Assert;
import com.tc.util.BaseBuildInfo;
import com.tc.util.BasePatchInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProductInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProductInfo.class);
    private static final String DATE_FORMAT = "yyyyMMdd-HHmmss";
    private static final Pattern KITIDPATTERN = Pattern.compile("(\\d+\\.\\d+.\\d+).*");
    private static final String BUILD_DATA_RESOURCE_NAME = "/build-data.txt";
    private static final String PATCH_DATA_RESOURCE_NAME = "/patch-data.txt";
    public static final String UNKNOWN_VALUE = "[unknown]";
    private static ProductInfo INSTANCE = null;
    private final BuildInfo buildInfo;
    private final List<PatchInfo> patchInfo = new ArrayList<PatchInfo>();
    private final List<ExtensionInfo> extensionInfo = new ArrayList<ExtensionInfo>();
    private final String kitID;
    private String buildID;

    ProductInfo(InputStream buildData, InputStream patchData) throws IOException {
        this(buildData, patchData, null, null, null);
    }

    ProductInfo(InputStream buildData, InputStream patchData, BuildInfo build, List<PatchInfo> patches, List<ExtensionInfo> extensions) throws IOException {
        Matcher matcher;
        Assert.assertNotNull("buildData", buildData);
        BaseBuildInfo baseBuild = new BaseBuildInfo(buildData);
        BasePatchInfo basePatch = new BasePatchInfo(patchData);
        this.buildInfo = build == null ? baseBuild : build;
        this.patchInfo.add(basePatch);
        if (patches != null) {
            this.patchInfo.addAll(patches);
        }
        Collections.sort(this.patchInfo, (a, b) -> b.count() - a.count());
        if (extensions != null) {
            this.extensionInfo.addAll(extensions);
        }
        this.kitID = (matcher = KITIDPATTERN.matcher(this.buildInfo.getVersion())).matches() ? matcher.group(1) : UNKNOWN_VALUE;
    }

    static Date parseTimestamp(String timestampString) throws ParseException {
        return timestampString == null ? null : new SimpleDateFormat(DATE_FORMAT).parse(timestampString);
    }

    public static ProductInfo getInstance() {
        return ProductInfo.getInstance(ProductInfo.class.getClassLoader());
    }

    public static synchronized ProductInfo getInstance(ClassLoader loader) {
        if (INSTANCE == null) {
            try {
                ServiceLoader<Description> additional = ServiceLoader.load(Description.class, loader);
                Iterator<Description> steps = additional.iterator();
                BuildInfo build = null;
                LinkedList<PatchInfo> patches = new LinkedList<PatchInfo>();
                LinkedList<ExtensionInfo> info = new LinkedList<ExtensionInfo>();
                while (steps.hasNext()) {
                    Description next = steps.next();
                    if (next instanceof BuildInfo) {
                        if (build != null) {
                            LOGGER.error("corrupt installation. multiple builds detected:\n{}\n\n{}", (Object)build, (Object)next);
                            throw new RuntimeException("corrupt installation. multiple builds detected");
                        }
                        build = (BuildInfo)next;
                    }
                    if (next instanceof PatchInfo) {
                        patches.add((PatchInfo)next);
                    }
                    if (!(next instanceof ExtensionInfo)) continue;
                    info.add((ExtensionInfo)next);
                }
                INSTANCE = new ProductInfo(ProductInfo.getBuildData(), ProductInfo.getPatchData(), build, patches, info);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return INSTANCE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static InputStream getData(String name) {
        CodeSource codeSource = ProductInfo.class.getProtectionDomain().getCodeSource();
        if (codeSource == null || codeSource.getLocation() == null) return ProductInfo.class.getResourceAsStream(name);
        URL source = codeSource.getLocation();
        if (source.getProtocol().equals("file") && source.toExternalForm().endsWith(".jar")) {
            try {
                URL res = new URL("jar:" + source.toExternalForm() + "!" + name);
                InputStream in = res.openStream();
                if (in == null) return ProductInfo.class.getResourceAsStream(name);
                return in;
            }
            catch (MalformedURLException e) {
                throw new AssertionError((Object)e);
            }
            catch (IOException e) {
                return ProductInfo.class.getResourceAsStream(name);
            }
        } else {
            File local;
            if (!source.getProtocol().equals("file") || !new File(source.getPath()).isDirectory() || !(local = new File(source.getPath(), name)).isFile()) return ProductInfo.class.getResourceAsStream(name);
            try {
                return new FileInputStream(local);
            }
            catch (FileNotFoundException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    static InputStream getBuildData() {
        return ProductInfo.getData(BUILD_DATA_RESOURCE_NAME);
    }

    static InputStream getPatchData() {
        return ProductInfo.getData(PATCH_DATA_RESOURCE_NAME);
    }

    public static void printRawData() {
    }

    public Collection<String> getExtensions() {
        return this.extensionInfo.stream().map(e -> e.getExtensionInfo()).collect(Collectors.toList());
    }

    public String moniker() {
        return this.buildInfo.getMonkier();
    }

    public String version() {
        return this.buildInfo.getVersion();
    }

    public String versionMessage() {
        return this.buildInfo.getVersionMessage();
    }

    public String mavenArtifactsVersion() {
        return this.buildInfo.getVersion();
    }

    public String buildVersion() {
        return this.buildInfo.getVersion();
    }

    public String kitID() {
        return this.kitID;
    }

    public String buildTimestamp() {
        return this.buildInfo.getTimestamp();
    }

    public String buildTimestampAsString() {
        return this.buildInfo.getTimestamp();
    }

    public String buildBranch() {
        return this.buildInfo.getBranch();
    }

    public String copyright() {
        return this.buildInfo.getCopyright();
    }

    public String buildRevision() {
        return this.buildInfo.getRevision();
    }

    public boolean isPatched() {
        PatchInfo info = this.patchInfo.get(0);
        if (info instanceof BasePatchInfo) {
            return ((BasePatchInfo)info).isPatched();
        }
        return true;
    }

    public String patchLevel() {
        return this.patchInfo.get(0).getLevel();
    }

    public String patchTimestamp() {
        return this.patchInfo.get(0).getTimestamp();
    }

    public String patchRevision() {
        return this.patchInfo.get(0).getRevision();
    }

    public String patchBranch() {
        return this.patchInfo.get(0).getBranch();
    }

    public String toShortString() {
        return this.buildInfo.getMonkier() + " " + this.buildInfo.getVersion();
    }

    public String toLongString() {
        return this.toShortString() + ", as of " + this.buildID();
    }

    public String buildID() {
        if (this.buildID == null) {
            this.buildID = this.buildInfo.getTimestamp() + " (Revision " + this.buildInfo.getRevision() + " from " + this.buildInfo.getBranch() + ")";
        }
        return this.buildID;
    }

    public String toLongPatchString() {
        return this.toShortPatchString() + ", as of " + this.patchBuildID();
    }

    public String toShortPatchString() {
        return "Patch Level " + this.patchInfo.get(0).getLevel();
    }

    public String patchBuildID() {
        return this.patchTimestamp() + " (Revision " + this.patchInfo.get(0).getRevision() + " from " + this.patchInfo.get(0).getBranch() + ")";
    }

    public String toString() {
        return this.toShortString();
    }
}

