/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.transport;

import com.tc.net.protocol.tcm.ClientMessageChannel;
import com.tc.net.protocol.transport.ClientConnectionEstablisher;
import com.tc.net.protocol.transport.ClientMessageTransport;
import com.tc.net.protocol.transport.MessageTransport;
import com.tc.net.protocol.transport.MessageTransportListener;
import com.tc.util.concurrent.SetOnceFlag;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionWatcher
implements MessageTransportListener {
    private static Logger LOGGER = LoggerFactory.getLogger(ConnectionWatcher.class);
    private final ClientMessageTransport cmt;
    private final ClientConnectionEstablisher cce;
    private final ReferenceQueue<ClientMessageChannel> stopQueue = new ReferenceQueue();
    private final SetOnceFlag stopped = new SetOnceFlag();
    private final WeakReference<ClientMessageChannel> targetHolder;

    public ConnectionWatcher(final ClientMessageTransport cmt, ClientMessageChannel target, ClientConnectionEstablisher cce) {
        this.cmt = cmt;
        this.targetHolder = new WeakReference<ClientMessageChannel>(target, this.stopQueue);
        this.cce = cce;
        cmt.addTransportListener(new MessageTransportListener(){

            @Override
            public void notifyTransportConnected(MessageTransport transport) {
                LOGGER.info("transport connected {} {} {}", new Object[]{ConnectionWatcher.this.targetHolder.get(), cmt, cmt.getConnectionID()});
            }

            @Override
            public void notifyTransportDisconnected(MessageTransport transport, boolean forcedDisconnect) {
                LOGGER.info("transport disconnected {} {} {}", new Object[]{ConnectionWatcher.this.targetHolder.get(), cmt, cmt.getConnectionID()});
            }

            @Override
            public void notifyTransportConnectAttempt(MessageTransport transport) {
                LOGGER.info("transport connect attempt {} {} {}", new Object[]{ConnectionWatcher.this.targetHolder.get(), cmt, cmt.getConnectionID()});
            }

            @Override
            public void notifyTransportClosed(MessageTransport transport) {
                LOGGER.info("transport closed {} {} {}", new Object[]{ConnectionWatcher.this.targetHolder.get(), cmt, cmt.getConnectionID()});
            }

            @Override
            public void notifyTransportReconnectionRejected(MessageTransport transport) {
                LOGGER.info("transport reconnect rejected {} {} {}", new Object[]{ConnectionWatcher.this.targetHolder.get(), cmt, cmt.getConnectionID()});
            }
        });
    }

    private boolean checkForStop() {
        Reference<ClientMessageChannel> target = this.stopQueue.poll();
        if (target != null && target == this.targetHolder) {
            this.stopped.set();
            LOGGER.warn("unreferenced connection left open {} {} {}", new Object[]{this.targetHolder.get(), this.cmt, this.cmt.getConnectionID()});
            this.cmt.close();
        }
        return this.stopped.isSet();
    }

    @Override
    public void notifyTransportClosed(MessageTransport transport) {
        this.cce.quitReconnectAttempts();
        MessageTransportListener target = (MessageTransportListener)this.targetHolder.get();
        if (target != null) {
            target.notifyTransportClosed(transport);
        }
    }

    @Override
    public void notifyTransportDisconnected(MessageTransport transport, boolean forcedDisconnect) {
        if (transport.getProductID().isReconnectEnabled()) {
            this.cce.asyncReconnect(this.cmt, this::checkForStop);
        } else {
            this.cce.quitReconnectAttempts();
            transport.close();
        }
        MessageTransportListener target = (MessageTransportListener)this.targetHolder.get();
        if (target != null) {
            target.notifyTransportDisconnected(transport, forcedDisconnect);
        }
    }

    @Override
    public void notifyTransportConnectAttempt(MessageTransport transport) {
        MessageTransportListener target = (MessageTransportListener)this.targetHolder.get();
        if (target != null) {
            target.notifyTransportConnectAttempt(transport);
        }
    }

    @Override
    public void notifyTransportConnected(MessageTransport transport) {
        MessageTransportListener target = (MessageTransportListener)this.targetHolder.get();
        if (target != null) {
            target.notifyTransportConnected(transport);
        }
    }

    @Override
    public void notifyTransportReconnectionRejected(MessageTransport transport) {
        this.cce.quitReconnectAttempts();
        MessageTransportListener target = (MessageTransportListener)this.targetHolder.get();
        if (target != null) {
            target.notifyTransportReconnectionRejected(transport);
        }
    }
}

