/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.transport;

import com.tc.net.protocol.transport.ConnectionID;
import com.tc.net.protocol.transport.ConnectionPolicy;
import com.tc.util.Assert;
import java.util.HashMap;
import java.util.HashSet;

public class ConnectionPolicyImpl
implements ConnectionPolicy {
    private final HashMap<String, HashSet<ConnectionID>> clientsByJvm = new HashMap();
    private final int maxConnections;
    private int maxReached;

    public ConnectionPolicyImpl(int maxConnections) {
        Assert.assertTrue("negative maxConnections", maxConnections >= 0);
        this.maxConnections = maxConnections;
    }

    @Override
    public synchronized boolean isConnectAllowed(ConnectionID connID) {
        if (connID.getProductId().isInternal() || !connID.isValid()) {
            return true;
        }
        HashSet<ConnectionID> jvmClients = this.clientsByJvm.get(connID.getJvmID());
        return jvmClients != null || !this.isMaxConnectionsReached();
    }

    public synchronized String toString() {
        return "ConnectionPolicy[maxConnections=" + this.maxConnections + ", connectedJvmCount=" + this.clientsByJvm.size() + "]";
    }

    @Override
    public synchronized boolean connectClient(ConnectionID connID) {
        if (connID.getProductId().isInternal() || connID.getChannelID() < 0L) {
            return true;
        }
        HashSet<ConnectionID> jvmClients = this.clientsByJvm.get(connID.getJvmID());
        if (this.isMaxConnectionsReached() && jvmClients == null) {
            return false;
        }
        if (jvmClients == null) {
            jvmClients = new HashSet();
            this.clientsByJvm.put(connID.getJvmID(), jvmClients);
            this.maxReached = this.clientsByJvm.size();
        }
        if (!jvmClients.contains(connID)) {
            jvmClients.add(connID);
        }
        return true;
    }

    @Override
    public synchronized void clientDisconnected(ConnectionID connID) {
        if (connID.getProductId().isInternal() || !connID.isValid()) {
            return;
        }
        HashSet<ConnectionID> jvmClients = this.clientsByJvm.get(connID.getJvmID());
        if (jvmClients == null) {
            return;
        }
        jvmClients.remove(connID);
        if (jvmClients.size() == 0) {
            this.clientsByJvm.remove(connID.getJvmID());
        }
    }

    @Override
    public synchronized boolean isMaxConnectionsReached() {
        return this.clientsByJvm.size() >= this.maxConnections;
    }

    @Override
    public synchronized int getMaxConnections() {
        return this.maxConnections;
    }

    @Override
    public synchronized int getNumberOfActiveConnections() {
        return this.clientsByJvm.size();
    }

    @Override
    public synchronized int getConnectionHighWatermark() {
        return this.maxReached;
    }
}

