/*
 * Decompiled with CFR 0.152.
 */
package com.tc.cluster;

import com.tc.net.protocol.tcm.ChannelEvent;
import com.tc.net.protocol.tcm.ChannelEventListener;
import com.tc.net.protocol.tcm.ChannelID;
import com.tc.net.protocol.tcm.ClientMessageChannel;
import com.tc.object.handshakemanager.ClientHandshakeManager;
import com.tc.util.CallStackTrace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientChannelEventController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientChannelEventController.class);
    private final ClientHandshakeManager clientHandshakeManager;
    private final ClientMessageChannel channel;

    public static void connectChannelEventListener(ClientMessageChannel channel, ClientHandshakeManager clientHandshakeManager) {
        ClientChannelEventController controller = new ClientChannelEventController(channel, clientHandshakeManager);
        channel.addListener(new ChannelEventListenerImpl(controller));
    }

    private ClientChannelEventController(ClientMessageChannel channel, ClientHandshakeManager clientHandshakeManager) {
        this.clientHandshakeManager = clientHandshakeManager;
        this.channel = channel;
    }

    private void channelOpened(ChannelEvent event) {
        LOGGER.debug("channel opened:" + event.getChannelID());
    }

    private void channelConnected(ChannelEvent event) {
        LOGGER.debug("channel connected:" + event.getChannelID());
        this.clientHandshakeManager.connected();
    }

    private void channelDisconnected(ChannelEvent event) {
        LOGGER.debug("channel disconnected:" + event.getChannelID());
        this.clientHandshakeManager.disconnected();
    }

    private void channelClosed(ChannelEvent event) {
        LOGGER.debug("channel closed:" + event.getChannelID());
        this.requestDisconnect();
    }

    private void channelReconnectionRejected() {
        LOGGER.debug("channel rejected");
        this.requestDisconnect();
    }

    private void requestDisconnect() {
        this.clientHandshakeManager.fireNodeError();
        this.clientHandshakeManager.shutdown();
        LOGGER.error("Reconnection was rejected from server, but rejoin is not enabled. This client will never be able to join the cluster again.");
    }

    private static class ChannelEventListenerImpl
    implements ChannelEventListener {
        private final ClientChannelEventController controller;

        public ChannelEventListenerImpl(ClientChannelEventController controller) {
            this.controller = controller;
        }

        @Override
        public void notifyChannelEvent(ChannelEvent event) {
            if (!event.getChannel().getProductID().isInternal()) {
                LOGGER.info("Got channel event - type: " + (Object)((Object)event.getType()) + ", event: " + event + CallStackTrace.getCallStack());
            }
            if (this.controller.clientHandshakeManager.isShutdown()) {
                return;
            }
            ChannelID eventChannelId = event.getChannelID();
            ClientMessageChannel currentChannel = this.controller.channel;
            if (eventChannelId != null && !currentChannel.getChannelID().equals(eventChannelId)) {
                LOGGER.info("Ignoring channel event " + (Object)((Object)event.getType()) + " for channel " + eventChannelId + " as currentChannel " + currentChannel.getChannelID());
                return;
            }
            switch (event.getType()) {
                case TRANSPORT_CONNECTED_EVENT: {
                    this.controller.channelConnected(event);
                    break;
                }
                case TRANSPORT_DISCONNECTED_EVENT: {
                    this.controller.channelDisconnected(event);
                    break;
                }
                case CHANNEL_CLOSED_EVENT: {
                    this.controller.channelClosed(event);
                    break;
                }
                case CHANNEL_OPENED_EVENT: {
                    this.controller.channelOpened(event);
                    break;
                }
                case TRANSPORT_RECONNECTION_REJECTED_EVENT: {
                    this.controller.channelReconnectionRejected();
                    break;
                }
                default: {
                    LOGGER.warn("Ignoring unexpected channel event " + (Object)((Object)event.getType()) + " for channel " + eventChannelId);
                }
            }
        }
    }
}

