/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.transport;

import com.tc.io.TCDataInput;
import com.tc.io.TCDataOutput;
import com.tc.net.ClientID;
import com.tc.net.core.ProductID;
import com.tc.net.protocol.tcm.ChannelID;
import java.io.IOException;

public class ConnectionID {
    private static final char DOT_PLACEHOLDER = '+';
    private static final char DOT = '.';
    private final long channelID;
    private final String serverID;
    private final String jvmID;
    private final Exception initEx;
    private final ProductID productId;
    private static final String NULL_SERVER_ID = "ffffffffffffffffffffffffffffffff";
    public static final String NULL_JVM_ID = "ffffffffffffffffffffffffffffffffffffffffffffffff";
    private static final ProductID DEFAULT_PRODUCT_ID = ProductID.PERMANENT;
    public static final ConnectionID NULL_ID = new ConnectionID("ffffffffffffffffffffffffffffffffffffffffffffffff", ChannelID.NULL_ID.toLong(), "ffffffffffffffffffffffffffffffff");
    private static final char SEP = '.';

    public ConnectionID(String jvmID, long channelID, String serverID) {
        this(jvmID, channelID, serverID, null);
    }

    public ConnectionID(String jvmID, long channelID, String serverID, ProductID productId) {
        this.jvmID = jvmID;
        this.channelID = channelID;
        this.serverID = serverID;
        this.initEx = jvmID.equals(NULL_JVM_ID) ? new Exception("Created (" + this.getID() + ") by:-----------------------------------------------------------") : null;
        this.productId = productId == null ? DEFAULT_PRODUCT_ID : productId;
    }

    public ConnectionID(String jvmID, long channelID, ProductID productId) {
        this(jvmID, channelID, NULL_SERVER_ID, productId);
    }

    public ConnectionID(String jvmID, long channelID) {
        this(jvmID, channelID, NULL_SERVER_ID);
    }

    public String toString() {
        return "ConnectionID(" + this.getID() + ")";
    }

    public boolean isNull() {
        return NULL_ID.equals(this);
    }

    public boolean isValid() {
        return this.channelID >= 0L;
    }

    public boolean isNewConnection() {
        return this.serverID.equals(NULL_SERVER_ID);
    }

    public String getServerID() {
        return this.serverID;
    }

    public int hashCode() {
        int hc = 17;
        hc = 37 * hc + (int)(this.channelID ^ this.channelID >>> 32);
        if (this.serverID != null) {
            hc = 37 * hc + this.serverID.hashCode();
        }
        return hc;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ConnectionID) {
            ConnectionID other = (ConnectionID)obj;
            return this.channelID == other.channelID && this.serverID.equals(other.serverID);
        }
        return false;
    }

    public long getChannelID() {
        return this.channelID;
    }

    public String getJvmID() {
        if (this.jvmID.equals(NULL_JVM_ID)) {
            throw new IllegalStateException("Attempt to get jvmID from pseudo-ConnectionID that was not initialized with one.", this.initEx);
        }
        return this.jvmID;
    }

    public boolean isJvmIDNull() {
        return this.jvmID.equals(NULL_JVM_ID);
    }

    public String getID() {
        StringBuilder sb = new StringBuilder(64);
        sb.append(this.channelID).append('.').append(this.serverID).append('.').append(this.jvmID).append('.').append((Object)this.productId);
        return sb.toString();
    }

    public void writeTo(TCDataOutput out) {
        out.writeLong(this.channelID);
        out.writeString(this.serverID);
        out.writeString(this.jvmID);
        out.writeString(this.productId.name());
        out.writeBoolean(false);
        out.writeBoolean(false);
    }

    public static ConnectionID readFrom(TCDataInput in) throws IOException {
        long channelID = in.readLong();
        String serverID = in.readString();
        String jvmID = in.readString();
        ProductID productId = ProductID.valueOf(in.readString());
        Object username = null;
        Object password = null;
        if (in.readBoolean()) {
            throw new AssertionError();
        }
        if (in.readBoolean()) {
            throw new AssertionError();
        }
        return new ConnectionID(jvmID, channelID, serverID, productId);
    }

    public ProductID getProductId() {
        return this.productId;
    }

    public ClientID getClientID() {
        return new ClientID(this.channelID);
    }

    public ConnectionID changeProductId(ProductID product) {
        return new ConnectionID(this.jvmID, this.channelID, this.serverID, product);
    }
}

