/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.common.internal.store;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.util.function.Predicate;
import org.ehcache.clustered.common.internal.util.ByteBufferInputStream;
import org.terracotta.utilities.classloading.FilteredObjectInputStream;

public class Util {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object unmarshall(ByteBuffer payload, Predicate<Class<?>> isClassPermitted) {
        try (FilteredObjectInputStream objectInputStream = new FilteredObjectInputStream(new ByteBufferInputStream(payload), isClassPermitted, null);){
            Object object = objectInputStream.readObject();
            return object;
        }
        catch (IOException | ClassNotFoundException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static byte[] marshall(Object message) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (ObjectOutputStream oout = new ObjectOutputStream(out);){
            oout.writeObject(message);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        return out.toByteArray();
    }
}

