/*
 * Decompiled with CFR 0.152.
 */
package com.tc.text;

public class Banner {
    private static final int MAX_LINE = 72;
    private static final int BOX_WIDTH = 76;

    public static void errorBanner(String message) {
        System.err.println(Banner.makeBanner(message, "ERROR"));
        System.err.flush();
    }

    public static void warnBanner(String message) {
        System.err.println(Banner.makeBanner(message, "WARNING"));
        System.err.flush();
    }

    public static void infoBanner(String message) {
        System.out.println(Banner.makeBanner(message, "INFO"));
        System.out.flush();
    }

    public static String makeBanner(String message, String type) {
        int i;
        int i2;
        if (message == null) {
            message = "<no message>";
        }
        int topStars = 76 - (type.length() + 2);
        int begin = topStars / 2;
        int end = topStars % 2 == 0 ? begin : begin + 1;
        StringBuffer buf = new StringBuffer();
        buf.append("\n");
        for (i2 = 0; i2 < begin; ++i2) {
            buf.append('*');
        }
        buf.append(' ').append(type).append(' ');
        for (i2 = 0; i2 < end; ++i2) {
            buf.append('*');
        }
        String[] lines = message.split("\n");
        for (i = 0; i < lines.length; ++i) {
            String[] words = lines[i].split(" ");
            int word = 0;
            if (words.length == 0) {
                buf.append("\n* ");
            }
            while (word < words.length) {
                int next;
                int length = words[word].length();
                buf.append("\n* ").append(words[word]);
                ++word;
                while (length <= 72 && word < words.length && length + (next = words[word].length() + 1) <= 72) {
                    buf.append(' ').append(words[word++]);
                    length += next;
                }
            }
        }
        buf.append("\n");
        for (i = 0; i < 76; ++i) {
            buf.append('*');
        }
        buf.append("\n");
        return buf.toString();
    }
}

